/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.extfilter.FilterGridUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcIndexEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject e) {
        DynamicObject valueBizObject;
        super.beforeBindData(e);
        PdsCommonUtils.setIsvId((IFormView)this.getView());
        DynamicObject bizObject = this.getModel().getDataEntity().getDynamicObject("bizobject");
        if (Objects.nonNull(bizObject)) {
            this.setComoItems(bizObject.getString("number"));
        }
        this.setPKeyFieldComoItems(this.getModel().getDataEntity().getString("pentitykey.number"));
        this.setMustInput();
        FilterGridUtils.setEntityNumber((IFormView)this.getView());
        if ("9".equals(this.getModel().getDataEntity().getString("valuetype")) && Objects.nonNull(valueBizObject = this.getModel().getDataEntity().getDynamicObject("valuebizobject"))) {
            PdsCommonUtils.setCombListValue((IFormView)this.getView(), (String)valueBizObject.getString("number"), (String)"fieldname");
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String opKey;
        super.beforeDoOperation(evt);
        switch (opKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "save": {
                this.verifyPlugin(evt);
                FilterGridUtils.saveCondition((IFormView)this.getView());
                if (this.getModel().getDataEntity().getBigDecimal("maxscore").compareTo(BigDecimal.ZERO) != 0) break;
                this.setMaxScore();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGridUtils.setCondition((IFormView)this.getView());
    }

    private void verifyPlugin(BeforeDoOperationEventArgs evt) {
        String pluginName = this.getModel().getDataEntity().getString("pluginname");
        if (!StringUtils.isBlank((CharSequence)pluginName) && !PdsCommonUtils.verifyExtPlugin((IFormView)this.getView())) {
            evt.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int index = e.getChangeSet()[0].getRowIndex();
        switch (fieldKey) {
            case "supplier": {
                if (Objects.isNull(newValue)) {
                    this.getModel().setValue("suppliername", null, index);
                    return;
                }
                if (!(newValue instanceof DynamicObject)) break;
                this.getModel().setValue("suppliername", (Object)((DynamicObject)newValue).getString("name"), index);
                break;
            }
            case "bizobject": {
                this.getModel().setValue("keyfield", null);
                this.getModel().setValue("pkeyfield", null);
                this.getModel().setValue("valuefield", null);
                this.getModel().setValue("datefield", null);
                this.getModel().setValue("orderby", null);
                this.setComoItems(Objects.isNull(newValue) ? null : ((DynamicObject)newValue).getString("number"));
                FilterGridUtils.setEntityNumber((IFormView)this.getView());
                break;
            }
            case "filtertype": {
                this.setMustInput();
                break;
            }
            case "pentitykey": {
                this.setPKeyFieldComoItems(Objects.isNull(newValue) ? null : ((DynamicObject)newValue).getString("number"));
                break;
            }
            case "itemscore": {
                this.setMaxScore();
                break;
            }
            case "valuebizobject": {
                if (!"9".equals(this.getModel().getDataEntity().getString("valuetype"))) break;
                PdsCommonUtils.setCombListValue((IFormView)this.getView(), Objects.isNull(newValue) ? null : ((DynamicObject)newValue).getString("number"), (String)"fieldname");
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs evt) {
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)evt.getEntryProp().getName())) {
            this.setMaxScore();
            return;
        }
    }

    private void setComoItems(String entityKey) {
        PdsCommonUtils.setCombListValue((IFormView)this.getView(), (String)entityKey, (String)"valuefield");
        PdsCommonUtils.setCombListValue((IFormView)this.getView(), (String)entityKey, (String)"datefield");
        PdsCommonUtils.setCombListValue((IFormView)this.getView(), (String)entityKey, (String)"keyfield");
        PdsCommonUtils.setCombListValue((IFormView)this.getView(), (String)entityKey, (String)"orderby");
    }

    private void setPKeyFieldComoItems(String entityKey) {
        PdsCommonUtils.setCombListValue((IFormView)this.getView(), (String)entityKey, (String)"pkeyfield");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit extfilter = (BasedataEdit)this.getControl("extfilter");
        if (Objects.nonNull(extfilter)) {
            extfilter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        String bizObjectNumber = this.getModel().getDataEntity().getString("bizobject.number");
        QFilter qFilter = null;
        switch (key = beforeF7SelectEvent.getProperty().getName()) {
            case "extfilter": {
                qFilter = new QFilter("basedata.number", "=", (Object)bizObjectNumber);
                qFilter.and("group.number", "=", (Object)"SYS14");
                listShowParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
        }
    }

    private void setMustInput() {
        String filtertype;
        switch (filtertype = PdsCommonUtils.object2String((Object)this.getModel().getDataEntity().get("filtertype"), (String)"")) {
            case "1": {
                this.getModel().setValue("pentitykey", null);
                this.getModel().setValue("pkeyfield", null);
                this.getModel().setValue("extplugin", null);
                this.getModel().setValue("extfilter", null);
                break;
            }
            case "2": {
                ((BasedataEdit)this.getView().getControl("pentitykey")).setMustInput(true);
                ((ComboEdit)this.getView().getControl("pkeyfield")).setMustInput(true);
                this.getModel().setValue("keyfield", null);
                this.getModel().setValue("extplugin", null);
                this.getModel().setValue("extfilter", null);
                break;
            }
            case "3": {
                ((TextEdit)this.getView().getControl("extplugin")).setMustInput(true);
                this.getModel().setValue("keyfield", null);
                this.getModel().setValue("pentitykey", null);
                this.getModel().setValue("pkeyfield", null);
                this.getModel().setValue("extfilter", null);
                break;
            }
            case "4": {
                ((BasedataEdit)this.getView().getControl("extfilter")).setMustInput(true);
                this.getModel().setValue("keyfield", null);
                this.getModel().setValue("pentitykey", null);
                this.getModel().setValue("pkeyfield", null);
                this.getModel().setValue("extplugin", null);
                break;
            }
        }
    }

    private void setMaxScore() {
        DynamicObjectCollection rows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            this.getModel().setValue("maxscore", null);
            return;
        }
        DynamicObject row = (DynamicObject)rows.stream().max((e1, e2) -> e1.getBigDecimal("itemscore").compareTo(e2.getBigDecimal("itemscore"))).get();
        BigDecimal maxScore = row.getBigDecimal("itemscore");
        if (maxScore.compareTo(BigDecimal.ZERO) > 0) {
            this.getModel().setValue("maxscore", (Object)maxScore);
        }
    }
}

