/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsPurlistUtils;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcMaterialchgEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject e) {
        this.createEntryEntity();
    }

    public void initialize() {
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        int index = evt.getChangeSet()[0].getRowIndex();
        if (index < 0) {
            return;
        }
        String fieldName = evt.getProperty().getName();
        if ("srcentryid".equals(fieldName) || "ischanged".equals(fieldName)) {
            return;
        }
        Object newValue = evt.getChangeSet()[0].getNewValue();
        switch (fieldName) {
            case "materialnane": {
                if (Objects.isNull(newValue) || StringUtils.isEmpty((String)newValue.toString())) {
                    Object oldValue = evt.getChangeSet()[0].getOldValue();
                    this.getModel().setValue("materialnane", oldValue, index);
                }
                this.getModel().setValue("ischanged", (Object)"1", index);
                break;
            }
            case "material": 
            case "materialmodel": 
            case "description": 
            case "category": 
            case "purlistentry_fj": 
            case "unit": 
            case "qty": {
                this.getModel().setValue("ischanged", (Object)"1", index);
                break;
            }
        }
    }

    private void createEntryEntity() {
        IFormView parentView = SrcBidChangeUtil.getParentView((IFormView)this.getView());
        if (parentView == null) {
            return;
        }
        DynamicObject bidChangeObj = parentView.getModel().getDataEntity();
        long pProjectId = SrmCommonUtil.getPkValue((DynamicObject)bidChangeObj.getDynamicObject("project"));
        if (pProjectId == 0L) {
            return;
        }
        long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getValue("projectid"));
        if (pProjectId == projectId) {
            return;
        }
        HashSet<String> excFields = new HashSet<String>();
        excFields.add("isnew");
        excFields.add("supplier");
        excFields.add("billtype");
        QFilter qfilter = new QFilter("project", "=", (Object)pProjectId);
        qfilter.and(new QFilter("billtype", "=", (Object)"1").or(new QFilter("billtype", "=", (Object)"2").and("isnew", "=", (Object)"1")));
        qfilter.and("isbizitem", "=", (Object)"0");
        this.getModel().beginInit();
        PdsCommonUtils.createEntryEntity((IFormView)this.getView(), (String)"src_purlistf7", (QFilter)qfilter, excFields, (String)"entryentity");
        this.getModel().endInit();
        this.getModel().setValue("projectid", (Object)pProjectId);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        IFormView parentView = SrcBidChangeUtil.getParentView((IFormView)this.getView());
        if (parentView == null) {
            return;
        }
        if (!PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        String propertyName = evt.getProperty().getName();
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)this.getView().getParentView().getModel().getDataEntity().getDynamicObject("project"));
        switch (propertyName) {
            case "material": {
                QFilter materialFilter = this.getMaterialFilter(projectId);
                evt.getCustomQFilters().add(materialFilter);
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit materialControl = (BasedataEdit)this.getView().getControl("material");
        if (null != materialControl) {
            materialControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private QFilter getMaterialFilter(long projectId) {
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and("supplier", "=", (Object)0L);
        Set purListEndIds = PdsPurlistUtils.getPurilstEndIds((long)projectId);
        qfilters.and("purlist.id", "not in", (Object)purListEndIds);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"material.id", (QFilter[])qfilters.toArray());
        Set materialIdSet = rows.stream().map(e -> e.getLong("material.id")).collect(Collectors.toSet());
        return new QFilter("id", "not in", materialIdSet);
    }
}

