/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.question.PdsQuestionFacade;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcGetDataByUserUtil;
import kd.scm.pds.common.validator.SrcCommonValidatorHelper;
import kd.scm.pds.formplugin.edit.PdsBillCompTplEdit;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.negopen.SrcNegOpenContext;
import kd.scm.src.common.negopen.SrcNegOpenFacade;
import kd.scm.src.formplugin.vie.SrcVieUtils;

public class SrcNegotiateBillEdit
extends PdsBillCompTplEdit {
    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.setPurOrgDefaultValue();
        SrcVieUtils.setNegotiatetypeCombList(this.getView());
        SrcVieUtils.setVieOperateVisible(this.getView());
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setRichTextValue();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        long billId = SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity());
        SrcVieUtils.vieOperateHandle(this.getView(), evt, billId, new CloseCallBack((IFormPlugin)this, evt.getItemKey()));
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String fieldName = evt.getProperty().getName();
        if (fieldName.equals("negotiatetype") || fieldName.equals("replenishtype")) {
            SrcVieUtils.setVieOperateVisible(this.getView());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "negopen": {
                this.negOpenConfirm(args);
                break;
            }
            case "addsupplier": {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
                this.addsupplier();
                break;
            }
            case "exit": {
                PdsCommonUtils.refreshParentView((IFormView)this.getView());
                this.getView().close();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "audit": {
                this.getView().invokeOperation("refresh");
                SrcVieUtils.setVieOperateVisible(this.getView());
                break;
            }
            case "delete": {
                long projectId = this.getModel().getDataEntity().getLong("project.id");
                SrcBidOpenFacade.setProjectOpenStatus((long)projectId);
                break;
            }
            case "answer": {
                PdsQuestionFacade.openQuestionList((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"src_question", (boolean)false);
                break;
            }
        }
        this.setRichTextValue();
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        OperationResult executeOperate;
        super.confirmCallBack(evt);
        if ("negopen".equals(evt.getCallBackId()) && evt.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0 && (executeOperate = OperationServiceHelper.executeOperate((String)"negopen", (String)this.getView().getEntityId(), (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, (OperateOption)OperateOption.create())).isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bae\u4ef7\u5f00\u6807\u6210\u529f\u3002", (String)"SrcNegotiateBillEdit_4", (String)"scm-src-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    private void negOpenConfirm(BeforeDoOperationEventArgs args) {
        args.setCancel(true);
        String message = SrcCommonValidatorHelper.validate((DynamicObject)this.getModel().getDataEntity(true), (String)this.getView().getEntityId(), (String)((AbstractOperate)args.getSource()).getOperateKey(), (IFormView)this.getView());
        if (message != null && message.length() > 0) {
            this.getView().showTipNotification(message);
            return;
        }
        SrcNegOpenContext context = SrcNegOpenFacade.getNegOpenTipMessage((DynamicObject)this.getModel().getDataEntity());
        if (context.isSucced()) {
            String title = ResManager.loadKDString((String)"\u5f00\u6807\u76f8\u5173\u4fe1\u606f\u5982\u4e0b\uff0c\u662f\u5426\u7ee7\u7eed\u5f00\u6807\uff1f", (String)"SrcNegotiateBillEdit_6", (String)"scm-src-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(title, String.format(ResManager.loadKDString((String)"%1$s", (String)"SrcNegotiateBillEdit_7", (String)"scm-src-formplugin", (Object[])new Object[0]), context.getMessage().toString()), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("negopen"));
        } else {
            this.getView().showTipNotification(context.getMessage().toString());
        }
    }

    private void addsupplier() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("entityname", this.getView().getEntityId());
        paramMap.put("project", SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity().getDynamicObject("project")));
        paramMap.put("billid", SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity()));
        paramMap.put("turns", this.getModel().getDataEntity().getString("turns"));
        OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_addsupplier", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "addsupplier"));
    }

    private void setRichTextValue() {
        IDataModel dataModel = this.getModel();
        if (dataModel.getValue("content") != null && dataModel.getValue("content").toString().length() > 0) {
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
            richTextEditor.setText(dataModel.getValue("content").toString());
        } else {
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
            richTextEditor.setText(ResManager.loadKDString((String)"\u8be5\u6587\u672c\u6846\u5185\u5bb9\u5bf9\u672c\u8f6e\u6240\u6709\u8bae\u6807\u4f9b\u5e94\u5546\u53ef\u89c1\uff0c\u8bf7\u6ce8\u610f\u8bdd\u672f\u7f16\u8f91\u3002", (String)"SrcNegotiateBillEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
    }

    private void setPurOrgDefaultValue() {
        long userId = RequestContext.get().getCurrUserId();
        List purOrgIds = SrcGetDataByUserUtil.getPurOrgSetByUserIdAndBillType((long)userId, (String)"src_negotiatebill");
        this.getModel().setValue("purorg", (Object)(purOrgIds.size() == 0 ? null : purOrgIds.toArray()));
        List purGroupIds = SrcGetDataByUserUtil.getPurGroupSetByUserIdAndBillType((long)userId, (String)"src_negotiatebill");
        this.getModel().setValue("purgroup", purGroupIds.size() == 0 ? null : purGroupIds.get(0));
        List purdeptIds = SrcGetDataByUserUtil.getPurdeptSetByUserIdAndBillType((long)userId, (String)"src_negotiatebill");
        this.getModel().setValue("purdept", purdeptIds.size() == 0 ? null : purdeptIds.get(0));
    }
}

