/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.feemanage.FeeManageUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcPayManageAssEdit
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addPackageDataListener(pkEvent -> {
            if (pkEvent.getSource() instanceof OperationColumn) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    boolean isVisible = FeeManageUtils.isButtonVisible((String)operationColItem.getOperationKey(), (String)pkEvent.getRowData().getString("paystatus"));
                    operationColItem.setVisible(isVisible);
                }
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        if (!Objects.equals(parentView.getEntityId(), "src_paymanage")) {
            return;
        }
        String billStatus = parentView.getModel().getDataEntity().getString("billstatus");
        if (!BillStatusEnum.AUDIT.getVal().equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"operation"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject paymentObj;
        super.beforeDoOperation(args);
        String opKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (("confirm".equals(opKey) || "reject".equals(opKey) || "exempt".equals(opKey) || "return".equals(opKey) || "transfer".equals(opKey) || "carryover".equals(opKey)) && null != (paymentObj = this.reLoadPaymentObj(args)) && FeeManageUtils.verifyPayStatus((String)opKey, (DynamicObject)paymentObj, (IFormView)this.getView())) {
            FeeManageUtils.openPaymentHandlePage((String)opKey, (DynamicObject)paymentObj, (IFormView)this.getView());
        }
    }

    private DynamicObject reLoadPaymentObj(BeforeDoOperationEventArgs args) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject paymentObj = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        long entryId = SrmCommonUtil.getPkValue((DynamicObject)paymentObj);
        if (entryId == 0L) {
            return null;
        }
        if (QueryServiceHelper.exists((String)"src_payment", (Object)entryId)) {
            return BusinessDataServiceHelper.loadSingle((Object)entryId, (String)"src_payment");
        }
        return null;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        EntryGrid grid = (EntryGrid)e.getSource();
        String gridKey = grid.getKey();
        String entityKey = null;
        String property = e.getFieldName();
        if ("entryentity".equals(gridKey) && ("billno".equals(property) || "supplier".equals(property))) {
            entityKey = "src_payment";
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject entrobj = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            if (null != entrobj) {
                this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)entityKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)PdsCommonUtils.object2Long((Object)entrobj.getPkValue()), new HashMap(), null));
            }
        }
    }
}

