/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.carryvalue.PdsCarryValueFacade;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.enums.PdsFlowConfigEnum;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.mytask.SrcMyTaskFacade;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsDefaultConfigUtil;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.pds.common.util.PdsParameterUtils;
import kd.scm.pds.common.util.SrcClarifyUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.extplugin.project.SrProjectSourceFlowHandler;
import kd.scm.src.common.util.SrcAppCache;
import kd.scm.src.common.util.SrcBidCompTplUtil;
import kd.scm.src.common.util.SrcNoticeSupUtil;
import kd.scm.src.common.util.SrcPackageUtil;
import kd.scm.src.common.util.SrcProjectUtil;
import kd.scm.src.common.util.SrcPurListUtil;
import org.apache.commons.lang3.StringUtils;

public class SrcProjectEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String KEY_SOURCETYPE = "sourcetype";
    private static final String KEY_SRCTYPE = "srctype";
    private static final String BASEINFOPAGEID = "baseinfopageid";
    private static final String WINRULEPAGEID = "winrulepageid";
    private static final String BAR_PUR_LIST = "barpurlist";
    private static final String PURDECISION = "purdecision";
    private static final String BAR_NOTICESUP = "bar_noticesup";
    private static String NOT_SHOW_MESSAGE = "notShowMessage";
    private static final String MANAGETYPE_CALLID = "managetype_callid";
    private static final String NEEDCLEARPACKAGE = "needclearpackage";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setPurlistStatus();
        this.setVisibleIsSplitdoc();
        this.setVisibleNoticeSup();
        this.setVisibleManageType();
        SrcProjectUtil.getManageTypeComboByTenderType((DynamicObject)this.getModel().getDataEntity(), (IFormView)this.getView());
        SrcProjectUtil.setSupplierVisible((DynamicObject)this.getModel().getDataEntity().getDynamicObject(KEY_SOURCETYPE), (IFormView)this.getView());
        SrcProjectUtil.setBaseInfoVisible((DynamicObject)this.getModel().getDataEntity().getDynamicObject(KEY_SOURCETYPE), (IFormView)this.getView());
        FieldEdit tenderType = (FieldEdit)this.getControl("tendertype");
        tenderType.setFieldKey(null);
        this.getModel().setDataChanged(false);
        SrcPackageUtil.setCreatePackageVisible((IFormView)this.getView());
    }

    private void setVisibleNoPackageSubmit() {
        QFilter packageFilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity()));
        if (QueryServiceHelper.exists((String)"src_packagef7", (QFilter[])packageFilter.toArray())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        SrcProjectUtil.setBizTypeDefaultValue((IDataModel)this.getModel());
        this.setVisibleSubmit();
        this.setVisibleCalculate(this.getModel().getDataEntity().getString("sourcetype.number"));
        this.getModel().setDataChanged(false);
    }

    private void setVisibleCalculate(String sourceType) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_calculate"});
        if (Objects.equals(sourceType, SourceTypeEnums.DIRECT_PUR.getValue()) || Objects.equals(sourceType, SourceTypeEnums.NET_PUR.getValue()) || Objects.equals(sourceType, SourceTypeEnums.INTERNAL_SALE.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_calculate"});
        }
    }

    private void setPurlistStatus() {
        Object billstatus = "";
        long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        DynamicObject purlistObj = QueryServiceHelper.queryOne((String)"src_purlist", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
        if (purlistObj != null) {
            billstatus = purlistObj.get("billstatus");
        }
        this.getModel().setValue("purlistStatus", billstatus);
    }

    private void setVisibleSubmit() {
        DynamicObject node;
        DynamicObject sourceTypeObj;
        boolean isContainPurlistComp = false;
        boolean isPurlistMainNode = false;
        DynamicObject obj = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryNodeCols = obj.getDynamicObjectCollection("entrymainflow");
        if ((null == entryNodeCols || entryNodeCols.size() == 0) && (sourceTypeObj = obj.getDynamicObject(KEY_SOURCETYPE)) != null) {
            String sourceType = sourceTypeObj.getString("number");
            if (SourceTypeEnums.CONFIRM_PRICE.getValue().equals(sourceType) || SourceTypeEnums.INPUT_PRICE.getValue().equals(sourceType) || SourceTypeEnums.NET_PUR.getValue().equals(sourceType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_PUR_LIST});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{BAR_PUR_LIST});
            }
        }
        if (null != (node = SrcBidCompTplUtil.getCurrNode((DynamicObject)obj, (String)"src_purlist", (boolean)false))) {
            if (SrcPurListUtil.isContainPurlistComp((IFormView)this.getView(), (IDataModel)this.getModel())) {
                isContainPurlistComp = true;
            } else if (!(node.getDataEntityType() instanceof SubEntryType)) {
                isPurlistMainNode = true;
            }
        }
        if (isContainPurlistComp) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit"});
            this.setVisibleNoPackageSubmit();
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_PUR_LIST});
            this.getView().setVisible(Boolean.FALSE, new String[]{"purlist"});
            return;
        }
        if (isPurlistMainNode) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit"});
            this.setVisibleNoPackageSubmit();
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_PUR_LIST});
            this.getView().setVisible(Boolean.FALSE, new String[]{"purlist"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{BAR_PUR_LIST});
        this.getView().setVisible(Boolean.FALSE, new String[]{"purlist"});
        boolean isAudit = SrcPurListUtil.checkPurlistStatus((IDataModel)this.getModel(), (String)BillStatusEnum.AUDIT.getVal());
        String billstatus = this.getModel().getDataEntity().getString("billstatus");
        if (!isAudit) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
        } else if (!"C".equals(billstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit"});
            this.setVisibleNoPackageSubmit();
        }
    }

    private void setVisibleNoticeSup() {
        this.getView().setVisible(Boolean.valueOf(PdsParameterUtils.isInviteByParam((IDataModel)this.getModel())), new String[]{BAR_NOTICESUP});
    }

    private void setVisibleManageType() {
        if (SrcPurListUtil.checkPurlistStatus((IDataModel)this.getModel(), (String)BillStatusEnum.SUBMIT.getVal())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"managetype", KEY_SRCTYPE});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"managetype", KEY_SRCTYPE});
        }
    }

    private void setVisibleIsSplitdoc() {
        if (SrcPurListUtil.checkPurlistStatus((IDataModel)this.getModel(), (String)BillStatusEnum.AUDIT.getVal()) && this.hasBidDocComp()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"issplitdoc"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"issplitdoc"});
        }
    }

    protected boolean hasBidDocComp() {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)billObj);
        return compKeyList.contains("src_biddoc_src");
    }

    public void registerListener(EventObject e) {
        BasedataEdit biztype;
        BasedataEdit supplierUserEdit;
        BasedataEdit region;
        BasedataEdit source;
        BasedataEdit sourcetype;
        BasedataEdit purorgEdit;
        super.registerListener(e);
        BasedataEdit srctypeEdit = (BasedataEdit)this.getView().getControl(KEY_SRCTYPE);
        if (srctypeEdit != null) {
            srctypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((purorgEdit = (BasedataEdit)this.getView().getControl("purorg")) != null) {
            purorgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((sourcetype = (BasedataEdit)this.getView().getControl(KEY_SOURCETYPE)) != null) {
            sourcetype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((source = (BasedataEdit)this.getView().getControl("source")) != null) {
            source.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((region = (BasedataEdit)this.getView().getControl("region")) != null) {
            region.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (supplierUserEdit = (BasedataEdit)this.getView().getControl("supplieruser"))) {
            supplierUserEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((biztype = (BasedataEdit)this.getView().getControl("biztype")) != null) {
            biztype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String sourceMethod = evt.getSourceMethod();
        String key = evt.getProperty().getName();
        String sourceMethodVal = "setItemByNumber";
        switch (key) {
            case "source": {
                this.setSourceSelect(evt);
                break;
            }
            case "srctype": {
                if (Objects.equals(sourceMethod, sourceMethodVal)) {
                    this.setSrctypeSelect(evt, false);
                    break;
                }
                this.setSrctypeSelect(evt, true);
                break;
            }
            case "sourcetype": {
                this.setSourceTypeSelect(evt);
                break;
            }
            case "supplieruser": {
                if (Objects.equals(sourceMethod, sourceMethodVal)) {
                    this.setSupplieruserSelect(evt, false);
                    break;
                }
                this.setSupplieruserSelect(evt, true);
                break;
            }
        }
    }

    private void setSourceSelect(BeforeF7SelectEvent evt) {
        List filters = evt.getCustomQFilters();
        DynamicObject typeObj = this.getModel().getDataEntity().getDynamicObject(KEY_SOURCETYPE);
        if (Objects.nonNull(typeObj)) {
            filters.add(new QFilter("entryentity.purtype.id", "=", typeObj.getPkValue()));
        }
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), null, (String)"src_project", (String)"47150e89000000ac");
        List purOrgs = hasPermOrgResult.getHasPermOrgs();
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            filters.add(new QFilter("org.id", "in", (Object)purOrgs));
        }
    }

    private void setSrctypeSelect(BeforeF7SelectEvent evt, boolean isShowMessage) {
        QFilter qfilter = new QFilter("entrynode.biznode", "!=", (Object)PdsBizNodeEnums.PREPROJECT.getId());
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qfilter);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        long sourcetypeId = this.getModel().getDataEntity().getLong("sourcetype.id");
        paramMap.put(KEY_SOURCETYPE, sourcetypeId);
        paramMap.put("ismustinput", "1");
        SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getModel().getDataEntity(), (String)"src_project_srctype_filter", paramMap);
    }

    private void setSourceTypeSelect(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter().getShowParameter();
        QFilter qFilter = null;
        DynamicObject source = (DynamicObject)this.getModel().getValue("source");
        if (Objects.nonNull(source)) {
            Object sourcePk = source.getPkValue();
            DynamicObject demand = BusinessDataServiceHelper.loadSingle((Object)sourcePk, (String)"src_demand");
            DynamicObjectCollection entrys = demand.getDynamicObjectCollection("entry");
            ArrayList<Object> ids = new ArrayList<Object>();
            for (DynamicObject entry : entrys) {
                if (!Objects.nonNull(entry.getDynamicObject("purtype"))) continue;
                ids.add(entry.getDynamicObject("purtype").getPkValue());
            }
            qFilter = new QFilter("id", "in", ids);
        }
        if (Objects.nonNull(qFilter)) {
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void setSupplieruserSelect(BeforeF7SelectEvent evt, boolean isShowMessage) {
        List filters = evt.getCustomQFilters();
        Object currSupObj = this.getModel().getValue("supplier");
        if (null == currSupObj) {
            if (isShowMessage) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (String)"SrcProjectEdit_7", (String)"scm-src-formplugin", (Object[])new Object[0]));
            }
            evt.setCancel(true);
            return;
        }
        long bizPartnerId = BizPartnerUtil.getBizPartnerBySupplier((Object)((DynamicObject)currSupObj).getLong("id"));
        QFilter qFilter = new QFilter("bizpartner", "=", (Object)bizPartnerId);
        filters.add(qFilter);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        DynamicObject obj = this.getModel().getDataEntity(true);
        long billId = PdsCommonUtils.object2Long((Object)obj.getPkValue());
        switch (key) {
            case "barpurlist": 
            case "purlist": {
                DynamicObject srctype = obj.getDynamicObject(KEY_SRCTYPE);
                if (srctype == null) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199%1$s\u3002", (String)"SrcProjectEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]), PdsMetadataUtil.getFieldDisplayName((Control)this.getControl(KEY_SRCTYPE))));
                    return;
                }
                String manageType = obj.getString("managetype");
                if (StringUtils.isBlank((CharSequence)manageType)) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199%1$s\u3002", (String)"SrcProjectEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]), PdsMetadataUtil.getFieldDisplayName((Control)this.getControl("managetype"))));
                    return;
                }
                DynamicObject orgTmp = obj.getDynamicObject("org_tmp");
                if (Objects.isNull(orgTmp)) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199%1$s\u3002", (String)"SrcProjectEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]), PdsMetadataUtil.getFieldDisplayName((Control)this.getControl("org_tmp"))));
                    return;
                }
                String billstatus = obj.getString("billstatus");
                if (billstatus == null || "".equals(billstatus) || "A".equals(billstatus)) {
                    this.getPageCache().put(NOT_SHOW_MESSAGE, "1");
                    OperationResult result = this.getView().invokeOperation("save");
                    if (!result.isSuccess()) break;
                    this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"src_purlist", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)billId, null, null));
                    break;
                }
                this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"src_purlist", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)billId, null, null));
                break;
            }
            case "bar_noticesup": {
                DynamicObject noticeObj = this.getModel().getDataEntity();
                SrcNoticeSupUtil.showNoticeSup((DynamicObject)noticeObj, (IFormView)this.getView());
                break;
            }
            case "notify": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u901a\u77e5\u76f8\u5173\u4eba\u5458\u8fdb\u884c\u5229\u76ca\u5173\u7cfb\u6f84\u6e05\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SrcProjectEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("notify"));
                evt.setCancel(true);
                break;
            }
            case "todotask": {
                QFilter qFilter = new QFilter("project", "=", (Object)billId);
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_memberclarify", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qFilter, null);
                break;
            }
            case "bar_calculate": {
                this.getPageCache().put(NOT_SHOW_MESSAGE, "1");
                OperationResult result = this.getView().invokeOperation("save");
                if (result.isSuccess()) break;
                evt.setCancel(true);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        IDataModel model = this.getModel();
        switch (key) {
            case "notify": {
                if (evt.getResult() != MessageBoxResult.Yes) {
                    return;
                }
                long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
                if (projectId == 0L) {
                    return;
                }
                Map notifyMap = SrcClarifyUtils.notifyAllMember((IFormView)this.getView(), (long)projectId, (String)"src_project_man");
                if (((Boolean)notifyMap.get("succed")).booleanValue()) {
                    this.getView().showSuccessNotification(notifyMap.get("message").toString());
                    this.getView().invokeOperation("refresh");
                    break;
                }
                this.getView().showTipNotification(notifyMap.get("message").toString());
                break;
            }
            case "managetype_callid": {
                MessageBoxResult result = evt.getResult();
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    DynamicObject billObj = this.getModel().getDataEntity(true);
                    SrcPackageUtil.updateCompPackageData((DynamicObject)billObj);
                    SrcPackageUtil.deletePackageData((DynamicObject)billObj);
                    this.getView().invokeOperation("reloadcomp");
                    break;
                }
                model.beginInit();
                model.setValue("managetype", (Object)"2");
                model.endInit();
                this.getView().updateView("managetype");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        String baseInfopageId = (String)SrcAppCache.get((String)BASEINFOPAGEID, String.class, (IFormView)this.getView());
        String winrulepageid = (String)SrcAppCache.get((String)WINRULEPAGEID, String.class, (IFormView)this.getView());
        String inviteSupplierId = this.getPageCache().get("src_supplier_invite");
        IFormView projectView = this.getView();
        switch (fieldKey) {
            case "srctype": {
                this.getPageCache().put(NEEDCLEARPACKAGE, "1");
                ChangeData[] newSrctype = e.getChangeSet();
                DynamicObject newSrctypeObject = newSrctype[0].getDataEntity().getDynamicObject(KEY_SRCTYPE);
                if (newSrctypeObject == null) {
                    this.getModel().setValue("isneedinvite", null);
                    this.getModel().setValue("template", null);
                    return;
                }
                if (newSrctypeObject.getBoolean("isneedinvite")) {
                    this.getModel().setValue("isneedinvite", (Object)"1");
                } else {
                    this.getModel().setValue("isneedinvite", (Object)"0");
                }
                SrcProjectUtil.getManageTypeComboByTenderType((DynamicObject)this.getModel().getDataEntity(), (IFormView)this.getView());
                this.setManageType(newSrctypeObject);
                this.setSourceSupplier(newSrctypeObject);
                PdsCarryValueFacade.carryValueToComponent((IFormView)this.getView(), (String)fieldKey, null);
                PdsDefaultConfigUtil.setDefaultValue((IFormView)this.getView());
                this.setVisibleSubmit();
                break;
            }
            case "sourcetype": {
                this.getPageCache().put(NEEDCLEARPACKAGE, "1");
                ChangeData[] newSourceType = e.getChangeSet();
                DynamicObject newSourceTypeObject = newSourceType[0].getDataEntity().getDynamicObject(KEY_SOURCETYPE);
                if (newSourceTypeObject == null) {
                    this.setVisibleCalculate(null);
                    return;
                }
                this.setVisibleCalculate(newSourceTypeObject.getString("number"));
                SrcProjectUtil.setDefaultOpenStatus((IDataModel)this.getModel(), (String)newSourceTypeObject.getString("number"));
                this.setWinrule(projectView, winrulepageid);
                this.newSourceBringSrctype(newSourceTypeObject);
                this.setSourceTypeToInvite(newSourceTypeObject);
                this.setSourceTypeToWinrule(newSourceTypeObject, projectView, winrulepageid);
                this.setSourceTypeToBaseInfo(newSourceTypeObject, projectView, baseInfopageId);
                SrcProjectUtil.setSupplierVisible((DynamicObject)newSourceTypeObject, (IFormView)this.getView());
                SrcProjectUtil.setBaseInfoVisible((DynamicObject)newSourceTypeObject, (IFormView)this.getView());
                PdsDefaultConfigUtil.setDefaultValue((IFormView)this.getView());
                break;
            }
            case "purdecision": {
                this.setPurdecisionToInvite(inviteSupplierId, e);
                break;
            }
            case "managetype": {
                SrcPackageUtil.setCreatePackageVisible((IFormView)this.getView());
                this.manageTypeChange(e);
                break;
            }
            case "currency": 
            case "taxtype": 
            case "decisiontype": {
                PdsCarryValueFacade.carryValueToComponent((IFormView)this.getView(), (String)fieldKey, null);
                this.getModel().setDataChanged(false);
                break;
            }
            case "supplier": {
                this.clearSupplierUser(projectView);
                break;
            }
            case "biztype": {
                SrcProjectUtil.resetSoureFlow((IFormView)this.getView(), (PropertyChangedArgs)e);
                break;
            }
        }
    }

    private void manageTypeChange(PropertyChangedArgs e) {
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        this.setManagetypeToSrcBiddoc();
        String needclearpackage = this.getPageCache().get(NEEDCLEARPACKAGE);
        if (StringUtils.isEmpty((CharSequence)needclearpackage) && null != newValue) {
            if ("2".equals(String.valueOf(oldValue))) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7ba1\u7406\u65b9\u5f0f\u6309\u6807\u6bb5\u5207\u6362\u65f6\uff0c\u5f15\u7528\u6807\u6bb5\u7684\u7ec4\u4ef6\u6570\u636e\u5c06\u88ab\u6e05\u9664\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\uff1f", (String)"SrcProjectEdit_5", (String)"scm-src-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(MANAGETYPE_CALLID, (IFormPlugin)this));
                return;
            }
        } else {
            this.getPageCache().remove(NEEDCLEARPACKAGE);
        }
        DynamicObject billObj = this.getModel().getDataEntity(true);
        SrcPackageUtil.updateCompPackageData((DynamicObject)billObj);
        SrcPackageUtil.deletePackageData((DynamicObject)billObj);
        this.getView().invokeOperation("reloadcomp");
    }

    private void setManageType(DynamicObject obj) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("managetype", (Object)obj.getString("managetype"));
        model.setValue(KEY_SOURCETYPE, (Object)obj.getLong("sourcetype.id"));
        model.endInit();
        this.getView().updateView("managetype");
        this.getView().updateView(KEY_SOURCETYPE);
    }

    private void setSourceSupplier(DynamicObject obj) {
        this.getModel().setValue("issourcesupplier", (Object)obj.getBoolean("issourcesupplier"));
    }

    private void setManagetypeToSrcBiddoc() {
        String key = "src_biddoc_src" + this.getView().getPageId();
        String srcBiddocPageId = (String)SrcAppCache.get((String)key, String.class, (IFormView)this.getView());
        IFormView srcBiddocView = this.getView().getView(srcBiddocPageId);
        if (srcBiddocView == null) {
            return;
        }
        IDataModel bidDocModel = srcBiddocView.getModel();
        if (null != bidDocModel && srcBiddocView.getModel().isDataLoaded()) {
            srcBiddocView.getModel().setValue("managetype", this.getModel().getValue("managetype"));
            this.getView().sendFormAction(srcBiddocView);
        }
    }

    private void setPurdecisionToInvite(String inviteSupplierId, PropertyChangedArgs e) {
        ChangeData[] newPurdecision = e.getChangeSet();
        IFormView inviteSupplierPage = this.getView().getView(inviteSupplierId);
        if (inviteSupplierPage == null) {
            return;
        }
        inviteSupplierPage.getModel().setValue(PURDECISION, (Object)newPurdecision);
        this.getView().sendFormAction(inviteSupplierPage);
    }

    private void setSourceTypeToBaseInfo(DynamicObject newSourceTypeObject, IFormView projectView, String baseInfopageId) {
        IFormView baseInfopage = projectView.getView(baseInfopageId);
        if (baseInfopage == null) {
            return;
        }
        if (newSourceTypeObject != null) {
            baseInfopage.getModel().setValue(KEY_SOURCETYPE, newSourceTypeObject.get("id"));
        }
        this.getView().sendFormAction(projectView.getView(baseInfopageId));
    }

    private void setSourceTypeToWinrule(DynamicObject newSourceTypeObject, IFormView projectView, String winrulepageid) {
        IFormView winrulepage = projectView.getView(winrulepageid);
        if (winrulepage == null) {
            return;
        }
        if (newSourceTypeObject != null) {
            winrulepage.getModel().setValue(KEY_SOURCETYPE, newSourceTypeObject.get("id"));
        }
        this.getView().sendFormAction(projectView.getView(winrulepageid));
    }

    private void setWinrule(IFormView projectView, String winrulepageid) {
        IFormView winrulepage = projectView.getView(winrulepageid);
        if (winrulepage == null) {
            return;
        }
        winrulepage.getModel().setValue("winrule", null);
        this.getView().sendFormAction(projectView.getView(winrulepageid));
    }

    private void newSourceBringSrctype(DynamicObject newSourceTypeObject) {
        this.getModel().setValue(KEY_SRCTYPE, null);
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        ExtPluginFactory.executeExtplugin((String)SrProjectSourceFlowHandler.class.getSimpleName(), (ExtPluginContext)context, (boolean)false);
    }

    private void setSourceTypeToInvite(DynamicObject newSourceTypeObject) {
        String invitePageId = (String)SrcAppCache.get((String)("src_supplier_invite" + this.getView().getPageId()), String.class, (IFormView)this.getView());
        IFormView invitePage = this.getView().getView(invitePageId);
        if (null == newSourceTypeObject || null == invitePage) {
            return;
        }
        invitePage.getModel().setValue(KEY_SOURCETYPE, (Object)newSourceTypeObject);
        this.getView().sendFormAction(invitePage);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String opKey;
        super.afterDoOperation(evt);
        long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        switch (opKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "save": {
                IPageCache cache = this.getPageCache();
                if (StringUtils.isNotBlank((CharSequence)cache.get(NOT_SHOW_MESSAGE))) {
                    evt.getOperationResult().setShowMessage(false);
                    cache.remove(NOT_SHOW_MESSAGE);
                }
                this.createMyTaskByMember();
                if (SrcPurListUtil.isContainPurlistComp((IFormView)this.getView(), (IDataModel)this.getModel())) {
                    DynamicObject purlistObj = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)"src_purlist");
                    SrcPurListUtil.updatePurListEntry((DynamicObject)purlistObj);
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "submit": {
                this.createMyTaskByMember();
                break;
            }
            case "audit": {
                if (this.isQuickPurchase()) {
                    return;
                }
                OperationResult result = evt.getOperationResult();
                if (null == result || !result.isSuccess() || !PdsParameterUtils.isInviteByParam((IDataModel)this.getModel()) || "2".equals(this.getModel().getDataEntity().getString("isneedinvite"))) break;
                String message = ResManager.loadKDString((String)"\u9879\u76ee\u542f\u52a8\u5ba1\u6838\u6210\u529f\uff0c\u8bf7\u53ca\u65f6\u53d1\u9001\u9080\u8bf7\u51fd\uff0c\u5426\u5219\u4f9b\u5e94\u5546\u5c06\u65e0\u6cd5\u6295\u6807\u3002", (String)"SrcProjectEdit_10", (String)"scm-src-formplugin", (Object[])new Object[0]);
                SrcNoticeSupUtil.notifySupplier((IFormView)this.getView(), (DynamicObject)this.getModel().getDataEntity(), (String)opKey, null, (String)message);
                break;
            }
            case "setopenstatus": {
                SrcBidOpenFacade.setProjectOpenStatus((long)projectId);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u5f00\u6807\u72b6\u6001\u6210\u529f\u3002", (String)"SrcProjectEdit_4", (String)"scm-src-formplugin", (Object[])new Object[0]));
                break;
            }
            case "aptitude": {
                OpenFormUtils.openBillPage((IFormView)this.getView(), (String)"src_aptitudeaudit", (Object)this.getModel().getDataEntity().getPkValue(), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
                break;
            }
            case "calculate": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "querynotice": {
                QFilter projectFilter = new QFilter("srcbillid", "=", (Object)projectId);
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"sou_notice", (ShowType)ShowType.MainNewTabPage, null, (QFilter)projectFilter, null);
                break;
            }
            case "extendparam": {
                this.openExtendParam(evt, projectId);
                break;
            }
            case "copycompdata": {
                this.copyCompData(evt, this.getModel().getDataEntity());
                break;
            }
            case "createpackage": {
                SrcPackageUtil.createPackage((IFormView)this.getView(), (DynamicObject)this.getModel().getDataEntity());
                break;
            }
        }
    }

    private void createMyTaskByMember() {
        SrcMyTaskContext context = new SrcMyTaskContext();
        context.setCurrView(this.getView());
        context.setProjectId(PdsCommonUtils.object2Long((Object)this.getView().getModel().getDataEntity().getPkValue()));
        context.setCompkey("src_project_man");
        SrcMyTaskFacade.createMyTaskByMember((SrcMyTaskContext)context);
    }

    private boolean isQuickPurchase() {
        DynamicObject sourceObj = this.getModel().getDataEntity().getDynamicObject("sourceclass");
        if (null == sourceObj) {
            return false;
        }
        return Objects.equals(PdsFlowConfigEnum.QUICK_PUR.getCode(), sourceObj.getString("number"));
    }

    private void openExtendParam(AfterDoOperationEventArgs evt, long projectId) {
        OperationResult result = evt.getOperationResult();
        if (null != result && result.isSuccess() && projectId > 0L) {
            QFilter qfilter = new QFilter("project", "=", (Object)projectId);
            HashMap<String, Long> paramMap = new HashMap<String, Long>(1);
            paramMap.put("projectid", projectId);
            OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_extendparam", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)qfilter, null);
        }
    }

    private void copyCompData(AfterDoOperationEventArgs evt, DynamicObject projectObj) {
        OperationResult result = evt.getOperationResult();
        long projectId = projectObj.getLong("id");
        if (null != result && result.isSuccess() && projectId > 0L) {
            if (projectObj.getLong("srctype.id") == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5bfb\u6e90\u6d41\u7a0b\uff0c\u518d\u8fdb\u884c\u590d\u5236\u3002", (String)"SrcProjectEdit_8", (String)"scm-src-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)projectObj.getString("managetype"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ba1\u7406\u65b9\u5f0f\uff0c\u518d\u8fdb\u884c\u590d\u5236\u3002", (String)"SrcProjectEdit_9", (String)"scm-src-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Long> paramMap = new HashMap<String, Long>(2);
            paramMap.put("projectid", projectId);
            OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_copycompdata", (ShowType)ShowType.Modal, paramMap, null);
        }
    }

    private void clearSupplierUser(IFormView projectView) {
        projectView.getModel().setValue("supplieruser", null);
    }
}

