/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.session.SessionQuery;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.mytask.SrcMyTaskFacade;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcClarifyUtils;
import kd.scm.src.common.util.SrcAppCache;
import kd.scm.src.common.util.SrcUsualUserUtils;
import org.apache.commons.lang3.StringUtils;

public class SrcProjectMemberJoinEdit
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        SrcAppCache.put((String)"projectMember", (Object)this.getView().getPageId(), (IFormView)this.getView().getParentView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        switch (fieldKey = e.getProperty().getName()) {
            case "bidder": {
                SrcUsualUserUtils.getUserInfo((IFormView)this.getView(), (int)e.getChangeSet()[0].getRowIndex());
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            int i;
            String entityId = parentView.getEntityId();
            DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
            this.getModel().beginInit();
            for (i = 0; i < rows.size(); ++i) {
                String userId = ((DynamicObject)rows.get(i)).getString("bidder.id");
                List sessions = SessionQuery.getUserSessions((String)RequestContext.get().getAccountId(), (String)userId);
                if (sessions == null || sessions.size() == 0) {
                    this.getModel().setValue("isonline", (Object)false, i);
                    continue;
                }
                this.getModel().setValue("isonline", (Object)true, i);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
            if ("src_bidpublish".equals(entityId)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
                for (i = 0; i < rows.size(); ++i) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"bizrole", "bidder", "position", "dept", "phone", "email", "note"});
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        switch (operateKey) {
            case "usualuser": {
                long billId = SrcUsualUserUtils.getBillId((String)this.getView().getEntityId());
                if (billId > 0L) {
                    OpenFormUtils.openBillPage((IFormView)this.getView(), (String)"src_usualuser", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, null, null);
                }
                args.setCancel(true);
                break;
            }
            case "notify": {
                if (Objects.equals(this.getView().getEntityId(), "src_project_reference")) {
                    Map notifyMap = SrcClarifyUtils.notifyAllMember((IFormView)this.getView(), (long)PdsCommonUtils.object2Long((Object)this.getView().getParentView().getModel().getDataEntity().getPkValue()), (String)this.getView().getEntityId());
                    this.getView().showTipNotification(notifyMap.get("message").toString());
                    if (((Boolean)notifyMap.get("succed")).booleanValue()) {
                        this.getView().invokeOperation("refresh");
                    }
                }
                args.setCancel(true);
                break;
            }
            case "submit": {
                this.deleteInvalidRows(this.getModel().getDataEntity(true));
                SrcMyTaskFacade.setBizRoleUsers((long)SrmCommonUtil.getPkValue((DynamicObject)this.getView().getParentView().getModel().getDataEntity()), (DynamicObjectCollection)this.getModel().getEntryEntity("entryentity"));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        switch (operateKey) {
            case "save": {
                this.createMyTaskByReference();
                this.getView().invokeOperation("refresh");
                break;
            }
            case "submit": {
                this.createMyTaskByReference();
                SrcUsualUserUtils.addToUsualUser((IFormView)this.getView());
                break;
            }
        }
    }

    private void createMyTaskByReference() {
        SrcMyTaskContext context = new SrcMyTaskContext();
        context.setCurrView(this.getView());
        context.setProjectId(PdsCommonUtils.object2Long((Object)this.getView().getParentView().getModel().getDataEntity().getPkValue()));
        context.setCompkey("src_project_reference");
        SrcMyTaskFacade.createMyTaskByReference((SrcMyTaskContext)context);
    }

    private void deleteInvalidRows(DynamicObject billObj) {
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return;
        }
        long projectId = Long.parseLong(billObj.getString("parentid"));
        Iterator iterator = rows.iterator();
        while (iterator.hasNext()) {
            DynamicObject obj = (DynamicObject)iterator.next();
            if (StringUtils.isEmpty((CharSequence)obj.getString("bidder"))) {
                iterator.remove();
                continue;
            }
            obj.set("project_id", (Object)projectId);
        }
        this.getView().updateView();
    }
}

