/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.pds.common.edit.AbstractBillImportEdit;
import kd.scm.pds.common.entity.ImportBaseDataName;
import kd.scm.pds.common.enums.PdsFlowConfigEnum;
import kd.scm.pds.common.util.PdsCalculateUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsCompConfigUtil;
import kd.scm.pds.common.util.SrcCalImpl;
import kd.scm.src.common.enums.SrcPurListResultEnum;
import kd.scm.src.common.enums.SrcSupplierTypeEnum;
import kd.scm.src.common.util.SrcComponentUtil;
import kd.scm.src.common.util.SrcQuickPurUtil;

public class SrcPurListImportEdit
extends AbstractBillImportEdit {
    private List<String> isImportProsList = null;
    private Map<String, String> mustInputProMap = null;
    public Map<String, DynamicObject> notNewPurListIdColMap = new HashMap<String, DynamicObject>(8);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initBtn();
    }

    public void initBtn() {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        String entityKey = parentView.getEntityId();
        if ("src_decision".equals(entityKey) && SrcQuickPurUtil.isQuickPurchase((IFormView)view, Collections.singletonList("src_decision"))) {
            view.setVisible(Boolean.TRUE, new String[]{"importdata"});
        }
    }

    protected String getExportDataTitile() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        String parentEntityKey = parentView.getEntityId();
        String entityKey = this.getModel().getDataEntityType().getName();
        String fileName = DateUtil.date2str((Date)new Date(), (String)"yyyyMMddHHmmss");
        String title = SrcComponentUtil.getCompTitleByBidComp((String)parentEntityKey, (String)entityKey);
        if (null != title) {
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)parentEntityKey);
            String parentName = type.getDisplayName().toString();
            String regEx = "[ \\\\`~!@#$%^*+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]|\n|\r|\t";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(parentName);
            while (m.find()) {
                String group = m.group(0);
                parentName = parentName.replace(group, "_");
            }
            fileName = parentName + title + fileName;
        }
        return fileName;
    }

    protected String getExportTplTitle() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        String parentEntityKey = this.getView().getParentView().getEntityId();
        String entityKey = this.getModel().getDataEntityType().getName();
        String fileName = ResManager.loadKDString((String)"\u6a21\u677f", (String)"SrcPurListImportEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]);
        String title = SrcComponentUtil.getCompTitleByBidComp((String)parentEntityKey, (String)entityKey);
        if (null != title) {
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)parentEntityKey);
            fileName = type.getDisplayName().toString() + title + fileName;
        }
        return fileName;
    }

    public void upload(UploadEvent uploadEvent) {
        super.upload(uploadEvent);
        this.getPageCache().remove("purlist_cal_by_import");
    }

    protected void beforeImport() {
        String entityKey;
        super.beforeImport();
        IFormView parentView = this.getView().getParentView();
        if (null != parentView && ("src_purlist".equals(entityKey = parentView.getEntityId()) || "src_project".equals(entityKey))) {
            this.getModel().deleteEntryData(this.getEntryKey());
        }
        this.getPageCache().put("purlist_cal_by_import", "1");
    }

    protected Set<String> getHighLevelProSet() {
        Set highLevelProSet = super.getHighLevelProSet();
        highLevelProSet.add("ispresent");
        highLevelProSet.add("isnew");
        highLevelProSet.add("result");
        return highLevelProSet;
    }

    protected void afterImport() {
        super.afterImport();
        SrcCalImpl cal = new SrcCalImpl();
        EntryGrid grid = (EntryGrid)this.getControl(this.getEntryKey());
        try {
            IDataModel model = this.getModel();
            String calPro = this.getCalPro();
            int rowCount = model.getEntryRowCount(this.getEntryKey());
            for (int i = 0; i < rowCount; ++i) {
                this.updateRowValAfterImport(i);
                grid.selectRows(i, true);
                cal.proChanged(this.getModel(), this.getEntryKey(), calPro);
            }
        }
        catch (Exception e) {
            BizLog.log((String)("after import error:" + e.getMessage()));
        }
        this.notNewPurListIdColMap.clear();
    }

    private String getCalPro() {
        IDataModel model = this.getModel();
        String taxType = model.getDataEntity().getString("taxtype");
        String decisionType = model.getDataEntity().getString("decisiontype");
        String calPro = "";
        if ("2".equals(decisionType)) {
            calPro = "taxamount";
            if ("2".equals(taxType)) {
                calPro = "amount";
            }
        } else {
            calPro = "taxprice";
            if ("2".equals(taxType)) {
                calPro = "price";
            }
        }
        return calPro;
    }

    public void updateRowValAfterImport(int rowIndex) {
        Set<String> resultValueSet;
        String result;
        DynamicObject material;
        IDataModel model = this.getModel();
        DynamicObject entryRow = model.getEntryRowEntity(this.getEntryKey(), rowIndex);
        DynamicObject supplier = entryRow.getDynamicObject("supplier");
        if (Objects.nonNull(supplier)) {
            model.setValue("suppliername", (Object)supplier.getString("name"), rowIndex);
        }
        if (Objects.nonNull(material = entryRow.getDynamicObject("material"))) {
            String description;
            model.setValue("materialnane", (Object)material.getString("name"), rowIndex);
            DynamicObject group = material.getDynamicObject("group");
            model.setValue("category", (Object)group, rowIndex);
            String matModel = entryRow.getString("materialmodel");
            if (StringUtils.isBlank((CharSequence)matModel)) {
                model.setValue("materialmodel", (Object)material.getString("modelnum"), rowIndex);
            }
            if (StringUtils.isBlank((CharSequence)(description = entryRow.getString("description")))) {
                model.setValue("description", (Object)material.getString("description"), rowIndex);
            }
        }
        if (Objects.nonNull(result = entryRow.getString("result")) && !(resultValueSet = this.getResultValueSet()).contains(result)) {
            model.setValue("orderratio", null, rowIndex);
        }
    }

    private Set<String> getResultValueSet() {
        HashSet<String> resultValueSet = new HashSet<String>(4);
        resultValueSet.add("1");
        resultValueSet.add("2");
        resultValueSet.add("5");
        resultValueSet.add("6");
        resultValueSet.add("7");
        return resultValueSet;
    }

    protected boolean validateDataByHighLevlePro(Map<String, Object> highLevelProValMap, Object setVal, String pro) {
        for (Map.Entry<String, Object> highLevelProValMapEntry : highLevelProValMap.entrySet()) {
            String highLevelPro = highLevelProValMapEntry.getKey();
            Object highProVal = highLevelProValMapEntry.getValue();
            if ("ispresent".equals(highLevelPro)) {
                if (null == highProVal) continue;
                if (highProVal instanceof Boolean && ((Boolean)highProVal).booleanValue()) {
                    switch (pro) {
                        case "price": 
                        case "taxitem": 
                        case "taxprice": 
                        case "currency": {
                            return true;
                        }
                    }
                }
            }
            if (!"result".equals(highLevelPro)) continue;
            String result = highProVal.toString();
            Set<String> resultValueSet = this.getResultValueSet();
            if (resultValueSet.contains(result)) continue;
            return true;
        }
        return super.validateDataByHighLevlePro(highLevelProValMap, setVal, pro);
    }

    protected void addComment(Map<String, String> commentMap) {
        super.addComment(commentMap);
        commentMap.put("taxitem", ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7a0e\u7387\u503c\uff0c\u793a\u4f8b\uff1a \u7a0e\u738713%\uff0c\u586b\u519913\u3002", (String)"SrcPurListImportEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
        commentMap.put("currency", ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5e01\u79cd\u7f16\u7801\uff0c\u793a\u4f8b\uff1aCNY/USD/HKD\u3002", (String)"SrcPurListImportEdit_2", (String)"scm-src-formplugin", (Object[])new Object[0]));
    }

    protected void addCellRangeList(Map<String, List<String>> cellRangeListMap) {
        super.addCellRangeList(cellRangeListMap);
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(SrcPurListResultEnum.WIN.getName());
        resultList.add(SrcPurListResultEnum.BACKUP.getName());
        resultList.add(SrcPurListResultEnum.CULTIVATE.getName());
        resultList.add(SrcPurListResultEnum.FAIL.getName());
        resultList.add(SrcPurListResultEnum.NOTRECOMMEND.getName());
        resultList.add(SrcPurListResultEnum.QUALIFIED.getName());
        cellRangeListMap.put("result", resultList);
    }

    protected void setColumn(ExcelDataEntity excelData) {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        String entityKey = this.getView().getEntityId();
        String parenteEntityKey = parentView.getEntityId();
        DynamicObject parentObj = parentView.getModel().getDataEntity(true);
        ArrayList<String> isExportProList = PdsCompConfigUtil.getPros((DynamicObject)parentObj, (String)entityKey, (String)this.getEntryKey(), (String)"isexport", (boolean)true);
        if (isExportProList.size() == 0) {
            super.setColumn(excelData);
            isExportProList = new ArrayList<String>(excelData.getColumnKeyList());
        }
        isExportProList.add("purlist");
        if ("src_compare".equals(parenteEntityKey) || "src_decision".equals(parenteEntityKey)) {
            isExportProList.add("srcentryid");
        }
        this.addSpecialPro(isExportProList);
        excelData.setColumnKeyList(isExportProList);
        this.removeUnValidColumnKey(excelData);
        List<ImportBaseDataName> virtualCols = this.getVirtualCol(excelData.getColumnKeyList());
        if (virtualCols != null && virtualCols.size() != 0) {
            this.setVirtualColAfterBaseData(virtualCols, excelData);
        }
    }

    private void setVirtualColAfterBaseData(List<ImportBaseDataName> virtualCols, ExcelDataEntity excelData) {
        ArrayList<String> columnKeyList = new ArrayList<String>(excelData.getColumnKeyList());
        if (columnKeyList.size() == 0) {
            return;
        }
        for (ImportBaseDataName virtualCol : virtualCols) {
            int index = columnKeyList.indexOf(virtualCol.getBaseDataLogo());
            if (index == -1 || columnKeyList.contains(virtualCol.getLogoName())) continue;
            columnKeyList.add(index + 1, virtualCol.getLogoName());
        }
        excelData.setColumnKeyList(columnKeyList);
    }

    private void addSpecialPro(List<String> visiableProList) {
        visiableProList.add(0, "project");
        if (this.isAdd()) {
            visiableProList.add(0, "isnew");
        }
    }

    protected void removeUnValidColumnKey(ExcelDataEntity excelData) {
        IDataModel model = this.getModel();
        ArrayList<String> needRemoveColumn = new ArrayList<String>();
        for (int i = 0; i < excelData.getColumnKeyList().size(); ++i) {
            DynamicProperty pro;
            String column = (String)excelData.getColumnKeyList().get(i);
            if ("purlistseq".equals(column) || null != (pro = (DynamicProperty)model.getDataEntityType().findProperty(column))) continue;
            needRemoveColumn.add(column);
        }
        needRemoveColumn.add("purlistentry_fj");
        needRemoveColumn.add("purlistentry_supfj");
        if (needRemoveColumn.size() == 0) {
            return;
        }
        List<Object> newColumnKeyList = new ArrayList(excelData.getColumnKeyList());
        newColumnKeyList.removeAll(needRemoveColumn);
        newColumnKeyList = newColumnKeyList.stream().distinct().collect(Collectors.toList());
        excelData.setColumnKeyList(newColumnKeyList);
    }

    protected List<ImportBaseDataName> getVirtualCol(List<String> columnKeyList) {
        if (columnKeyList == null || columnKeyList.size() == 0) {
            return null;
        }
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        List<String> unVirtualCols = this.unVirtual();
        ArrayList<ImportBaseDataName> virtualList = new ArrayList<ImportBaseDataName>();
        for (String column : columnKeyList) {
            IDataEntityProperty pro = dataEntityType.findProperty(column);
            if (unVirtualCols.contains(column) || !(pro instanceof BasedataProp)) continue;
            ImportBaseDataName virtualCol = this.setVirtualCol(column, pro);
            virtualList.add(virtualCol);
        }
        return virtualList;
    }

    protected ImportBaseDataName setVirtualCol(String column, IDataEntityProperty pro) {
        ImportBaseDataName importBaseDataName = new ImportBaseDataName();
        importBaseDataName.setBaseDataLogo(column);
        importBaseDataName.setChName(String.format(ResManager.loadKDString((String)"%1$s\u540d\u79f0", (String)"SrcPurListImportEdit_13", (String)"scm-src-formplugin", (Object[])new Object[0]), pro.getDisplayName()));
        importBaseDataName.setLogoName(column + "_name");
        switch (column) {
            case "lgort": {
                importBaseDataName.setBaseDataQueryName("name1");
                break;
            }
            default: {
                importBaseDataName.setBaseDataQueryName("name");
            }
        }
        return importBaseDataName;
    }

    protected void setExcelHeader(ExcelDataEntity excelDataEntity, IDataModel model) throws IOException {
        Map<String, String> mustInputProMap = this.getMustInputProMap();
        ArrayList<String> columnTitleList = new ArrayList<String>();
        Integer rowCount = 0;
        ArrayList<Integer> mustInputIndexList = new ArrayList<Integer>();
        List<ImportBaseDataName> virtualCols = this.getVirtualCol(excelDataEntity.getColumnKeyList());
        for (int i = 0; i < excelDataEntity.getColumnKeyList().size(); ++i) {
            Integer n;
            Integer n2;
            String column = (String)excelDataEntity.getColumnKeyList().get(i);
            DynamicProperty pro = (DynamicProperty)model.getDataEntityType().findProperty(column);
            StringBuilder headTitileSb = new StringBuilder();
            if (null != pro) {
                String configKey = this.getEntryKey() + "." + column;
                if (null != mustInputProMap.get(configKey)) {
                    headTitileSb.append('*');
                    mustInputIndexList.add(rowCount);
                } else if ("purlist".equals(column)) {
                    headTitileSb.append(ResManager.loadKDString((String)"*(\u52ff\u6539\u52ff\u5220)", (String)"SrcPurListImportEdit_4", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    mustInputIndexList.add(rowCount);
                }
                headTitileSb.append(pro.getDisplayName());
                if (excelDataEntity.isAddColumnKeyToHeader()) {
                    headTitileSb.append("${").append(column).append('}');
                }
                columnTitleList.add(headTitileSb.toString());
                n2 = rowCount;
                n = rowCount = Integer.valueOf(rowCount + 1);
                continue;
            }
            if (column.equals("purlistseq")) {
                headTitileSb.append(ResManager.loadKDString((String)"\u884c\u53f7", (String)"SrcPurListImportEdit_5", (String)"scm-src-formplugin", (Object[])new Object[0]));
                if (excelDataEntity.isAddColumnKeyToHeader()) {
                    headTitileSb.append("${").append(column).append('}');
                }
                columnTitleList.add(headTitileSb.toString());
                Integer configKey = rowCount;
                n2 = rowCount = Integer.valueOf(rowCount + 1);
                continue;
            }
            boolean flag = virtualCols.stream().anyMatch(e -> e.getLogoName().equals(column));
            if (!flag) continue;
            List importBaseDataName = virtualCols.stream().filter(e -> e.getLogoName().equals(column)).collect(Collectors.toList());
            headTitileSb.append(((ImportBaseDataName)importBaseDataName.get(0)).getChName());
            if (excelDataEntity.isAddColumnKeyToHeader()) {
                headTitileSb.append("${").append(column).append('}');
            }
            columnTitleList.add(headTitileSb.toString());
            n = rowCount;
            Integer n3 = rowCount = Integer.valueOf(rowCount + 1);
        }
        excelDataEntity.setExcelHeader(columnTitleList);
        this.setColumnTitleColor(excelDataEntity, mustInputIndexList);
    }

    protected void setEexclBody(ExcelDataEntity excelDataEntity) throws IOException {
        List columnKeyList = excelDataEntity.getColumnKeyList();
        List<DynamicObject> groupDataList = this.getEntryGroupData();
        for (int i = 0; i < groupDataList.size(); ++i) {
            List<Object> rowData = this.getRowDataByIndex(columnKeyList, groupDataList.get(i), i);
            excelDataEntity.createRow(0, i + 1);
            this.setRowValue(excelDataEntity, 0, i + 1, rowData);
        }
    }

    public List<DynamicObject> getEntryGroupData() {
        DynamicObjectCollection cols = this.getModel().getEntryEntity(this.getEntryKey());
        return cols.stream().collect(Collectors.toList());
    }

    protected boolean isAddNew() {
        String entityKey;
        IFormView parentView = this.getView().getParentView();
        if (null != parentView && ("src_compare".equals(entityKey = parentView.getEntityId()) || "src_decision".equals(entityKey) || "src_negotiatebill".equals(entityKey))) {
            return false;
        }
        String userType = RequestContext.get().getUserType();
        if (userType != null && userType.contains("3")) {
            return this.isAdd();
        }
        return super.isAddNew();
    }

    private List<Object> getRowDataByIndex(List<String> columnKeyList, DynamicObject col, int i) {
        ArrayList<Object> rowData = new ArrayList<Object>(10);
        if (null == col) {
            col = this.getModel().getEntryRowEntity(this.getEntryKey(), i);
        }
        List<ImportBaseDataName> virtualCols = this.getVirtualCol(columnKeyList);
        for (String column : columnKeyList) {
            Object val = "";
            boolean flag = virtualCols.stream().anyMatch(e -> e.getLogoName().equals(column));
            if (flag) {
                List importBaseDataName = virtualCols.stream().filter(e -> e.getLogoName().equals(column)).collect(Collectors.toList());
                val = this.getVirtualVal(col, (ImportBaseDataName)importBaseDataName.get(0));
            } else {
                val = this.getRowVal(col, column, i);
            }
            rowData.add(val);
        }
        return rowData;
    }

    private String getVirtualVal(DynamicObject col, ImportBaseDataName importBaseDataName) {
        DynamicObject object = col.getDynamicObject(importBaseDataName.getBaseDataLogo());
        if (object == null) {
            return "";
        }
        try {
            String val = object.getString(importBaseDataName.getBaseDataQueryName());
            return val;
        }
        catch (ORMDesignException e) {
            return "";
        }
    }

    public Object getRowVal(DynamicObject col, String column, int index) {
        Object val = "";
        Object columnVal = null;
        if ("purlistseq".equals(column)) {
            DynamicObject purListObj = col.getDynamicObject("purlist");
            if (null == purListObj) {
                return "";
            }
            val = purListObj.get("purlistseq");
        } else if ("suppliername".equals(column)) {
            DynamicObject supplier = col.getDynamicObject("supplier");
            val = supplier != null ? supplier.get("name") : col.get(column);
        } else if ("project".equals(column)) {
            DynamicObject project = col.getDynamicObject(column);
            val = project != null ? project.get("bidname") : "";
        } else if ("sysresult".equals(column) || "result".equals(column)) {
            val = SrcPurListResultEnum.getNameByValue((String)col.getString(column));
        } else {
            try {
                columnVal = col.get(column);
            }
            catch (Exception e) {
                BizLog.log((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u503c\u5931\u8d25\uff1a%1$s\u3002", (String)"SrcPurListImportEdit_14", (String)"scm-src-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
            if (columnVal == null) {
                val = "";
            } else if (null != columnVal && columnVal instanceof DynamicObject) {
                if ("purlist".equals(column)) {
                    val = ((DynamicObject)columnVal).get("entryid");
                    val = "'" + val;
                } else if (column.equals("project")) {
                    val = ((DynamicObject)columnVal).get("billno");
                } else if (column.equals("package")) {
                    val = ((DynamicObject)columnVal).get("packagename");
                } else if (column.equals("taxitem")) {
                    val = ((DynamicObject)columnVal).getBigDecimal("taxrate");
                    val = ((BigDecimal)val).stripTrailingZeros().toPlainString();
                } else {
                    val = ((DynamicObject)columnVal).get(this.getBdPro(column));
                }
            } else if (columnVal instanceof BigDecimal) {
                val = ((BigDecimal)columnVal).compareTo(BigDecimal.ZERO) == 0 ? "" : ((BigDecimal)columnVal).setScale(this.getScale(col, column, index), RoundingMode.HALF_UP);
            } else if (columnVal instanceof Boolean) {
                val = ((Boolean)columnVal).booleanValue() ? ResManager.loadKDString((String)"\u662f", (String)"SrcPurListImportEdit_7", (String)"scm-src-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"SrcPurListImportEdit_8", (String)"scm-src-formplugin", (Object[])new Object[0]);
            } else if (columnVal instanceof Date) {
                IDataEntityProperty pro = this.findPro(column);
                val = pro instanceof DateTimeProp ? ((DateTimeProp)pro).getDateFormat().format(columnVal) : DateUtil.date2str((Date)((Date)columnVal), (String)"yyyy-MM-dd");
            } else if (columnVal instanceof DynamicObjectCollection) {
                if ("purlistentry_fj".equals(column) || "purlistentry_supfj".equals(column)) {
                    val = "";
                }
            } else if ("result".equals(column)) {
                SrcPurListResultEnum result = SrcPurListResultEnum.fromVal((String)String.valueOf(columnVal));
                if (null != result) {
                    val = result.getName();
                }
            } else {
                val = columnVal;
            }
        }
        return val;
    }

    public int getScale(DynamicObject col, String column, int rowIndex) {
        int scale = 6;
        if ("qty".equals(column)) {
            IDataModel model = this.getModel();
            Object unit = model.getValue("unit", rowIndex);
            if (unit instanceof DynamicObject) {
                scale = ((DynamicObject)unit).getInt("precision");
                return scale;
            }
        } else {
            scale = super.getScale(col, column, rowIndex);
        }
        return scale;
    }

    protected void addUniqueColumn(List<String> uniqueColumnList) {
        super.addUniqueColumn(uniqueColumnList);
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        String entityKey = parentView.getEntityId();
        if (("src_compare".equals(entityKey) || "src_decision".equals(entityKey)) && !this.isQuickPurchase()) {
            uniqueColumnList.add("srcentryid");
            return;
        }
        uniqueColumnList.add("purlist");
        if ("src_compare".equals(entityKey) || "src_decision".equals(entityKey) || "src_directpur".equals(entityKey) || "src_negotiatebill".equals(entityKey)) {
            uniqueColumnList.add("supplier");
        }
    }

    private boolean isQuickPurchase() {
        boolean isQuickPurchase = false;
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return isQuickPurchase;
        }
        DynamicObject sourceObj = parentView.getModel().getDataEntity().getDynamicObject("sourceclass");
        if (null == sourceObj) {
            return isQuickPurchase;
        }
        if (Objects.equals(PdsFlowConfigEnum.QUICK_PUR.getCode(), sourceObj.getString("number"))) {
            isQuickPurchase = true;
        }
        return isQuickPurchase;
    }

    protected String getGroupVal(DynamicObject col, String pro) {
        DynamicObject proVal;
        if ("purlist".equals(pro) && null != (proVal = col.getDynamicObject(pro))) {
            return String.valueOf(proVal.get("entryid"));
        }
        return super.getGroupVal(col, pro);
    }

    public boolean isRepeat(Set<String> importUniqueValSet, String uniqueColumnVal, int index) {
        if (this.isAdd() && this.isImportRowAddNew(index)) {
            return false;
        }
        return super.isRepeat(importUniqueValSet, uniqueColumnVal, index);
    }

    public Integer getUpdateRowIndex(Map<String, Integer> columnIndexMap, String uniqueColumnVal, int index) {
        if (this.isAdd() && this.isImportRowAddNew(index)) {
            return null;
        }
        return super.getUpdateRowIndex(columnIndexMap, uniqueColumnVal, index);
    }

    public void groupEntryData(Map<String, DynamicObject> uniqueColumnColMap, Map<String, Integer> columnIndexMap) {
        if (this.isAdd()) {
            List uniqueColumnList = this.getUniqueColumnList();
            int rowIndex = 0;
            DynamicObjectCollection cols = this.getModel().getEntryEntity(this.getEntryKey());
            for (DynamicObject col : cols) {
                boolean isNew = col.getBoolean("isnew");
                if (!isNew) {
                    String valStr = this.getGroupVal(col, uniqueColumnList);
                    uniqueColumnColMap.put(valStr, col);
                    columnIndexMap.put(valStr, rowIndex);
                }
                ++rowIndex;
            }
        } else {
            super.groupEntryData(uniqueColumnColMap, columnIndexMap);
        }
    }

    protected Object getVal(String column, int index, Object val, StringBuilder msg) {
        Object proVal;
        List<String> proList = this.getIsImportPros();
        boolean isAdd = this.isAdd();
        if (proList != null) {
            if (isAdd && this.isImportRowAddNew(index)) {
                proList.add("materialnane");
                proList.add("category");
                proList.add("purlist");
                proList.add("materialmodel");
                proList.add("brand");
            }
            if (!proList.contains(column)) {
                return null;
            }
        }
        if ("result".equals(column) || "sysresult".equals(column)) {
            SrcPurListResultEnum result = SrcPurListResultEnum.fromName((String)String.valueOf(val));
            if ("-1".equals(result.getValue())) {
                IDataEntityProperty pro = this.getModel().getDataEntityType().findProperty(column);
                msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u503c\u5f55\u5165\u4e0d\u6b63\u786e\u3002", (String)"SrcPurListImportEdit_17", (String)"scm-src-formplugin", (Object[])new Object[0]), pro.getDisplayName())).append('\n');
                return "";
            }
            return result.getValue();
        }
        if ("isdiscarded".equals(column)) {
            int rowIndex;
            IDataModel model = this.getModel();
            Object discardBid = model.getValue("isdiscardbid", rowIndex = model.getEntryCurrentRowIndex(this.getEntryKey()));
            if (!((Boolean)discardBid).booleanValue()) {
                return 0;
            }
        } else {
            if ("supplier".equals(column)) {
                return this.dealSupplier(val, msg);
            }
            if ("suppliertype".equals(column)) {
                return this.dealSupplierType(val, msg);
            }
            if ("purlistseq".equals(column)) {
                return null;
            }
            if ("purlist".equals(column)) {
                String purlistIdStr = String.valueOf(val).replaceAll("'", "");
                Map<String, DynamicObject> purListIdColMap = this.getNotNewPurlistIdColMap();
                if (null == purListIdColMap.get(purlistIdStr)) {
                    msg.append(ResManager.loadKDString((String)"{purlist}\u6807\u7684id\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u662f\u590d\u5236\u5df2\u6709\u7684\u6570\u636eid\u3002", (String)"SrcPurListImportEdit_15", (String)"scm-src-formplugin", (Object[])new Object[0])).append('\n');
                    return 0;
                }
                return Long.valueOf(purlistIdStr);
            }
            if ("project".equals(column)) {
                return 0;
            }
            if ("materialnane".equals(column)) {
                if (isAdd && StringUtils.isBlank((Object)val)) {
                    val = null;
                }
            } else if ("orderratio".equals(column)) {
                if (StringUtils.isBlank((Object)val)) {
                    return 0;
                }
                BigDecimal onehundred = new BigDecimal("100");
                BigDecimal orderRatio = BigDecimal.valueOf(Long.parseLong(val.toString()));
                if (orderRatio.compareTo(BigDecimal.ZERO) < 0 || orderRatio.compareTo(onehundred) > 0) {
                    IDataEntityProperty pro = this.getModel().getDataEntityType().findProperty(column);
                    msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u7684\u6570\u636e\u8303\u56f4\u5e94\u4e3a0\u81f3100\u3002", (String)"SrcPurListImportEdit_16", (String)"scm-src-formplugin", (Object[])new Object[0]), pro.getDisplayName())).append('\n');
                    return 0;
                }
            }
        }
        if (null == (proVal = super.getVal(column, index, val, msg))) {
            IDataEntityProperty pro;
            StringBuilder configKeySb = new StringBuilder();
            configKeySb.append(this.getEntryKey()).append('.').append(column);
            Map<String, String> mustInputProMap = this.getMustInputProMap();
            if (null != mustInputProMap.get(configKeySb.toString()) && msg.length() == 0 && null != (pro = this.getModel().getDataEntityType().findProperty(column))) {
                msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u5fc5\u5f55\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcPurListImportEdit_10", (String)"scm-src-formplugin", (Object[])new Object[0]), pro.getDisplayName())).append('\n');
            }
        }
        return proVal;
    }

    private Object dealSupplier(Object val, StringBuilder msg) {
        if (val != null) {
            QFilter qFilter = new QFilter("number", "=", val);
            DynamicObject bdSupplier = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (bdSupplier != null) {
                return bdSupplier.get("id");
            }
            qFilter = new QFilter("number", "=", val);
            DynamicObject srmSupplier = QueryServiceHelper.queryOne((String)"src_supplier", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (srmSupplier != null) {
                return srmSupplier.get("id");
            }
            DynamicObject unregSupplier = QueryServiceHelper.queryOne((String)"src_supplier_tmp", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (unregSupplier != null) {
                return unregSupplier.get("id");
            }
            msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c\u4f9b\u5e94\u5546\u201d\u7cfb\u7edf\u4e2d\u6ca1\u6709\u503c\u4e3a'%1$s'\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"SrcPurListImportEdit_11", (String)"scm-src-formplugin", (Object[])new Object[0]), val)).append('\n');
        }
        return val;
    }

    private Object dealSupplierType(Object val, StringBuilder msg) {
        if ("-1".equals(String.valueOf(val = SrcSupplierTypeEnum.getValueByName((String)String.valueOf(val))))) {
            msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c\u4f9b\u5e94\u5546\u7c7b\u522b\u201d\u7cfb\u7edf\u4e2d\u6ca1\u6709\u503c\u4e3a'%1$s'\u7684\u6570\u636e\u3002", (String)"SrcPurListImportEdit_12", (String)"scm-src-formplugin", (Object[])new Object[0]), val)).append('\n');
        }
        return val;
    }

    protected Object getBdVal(String column, String bdKey, Object val) {
        if (column.equals("taxitem")) {
            return this.getTaxItem(val, bdKey);
        }
        return super.getBdVal(column, bdKey, val);
    }

    private Object getTaxItem(Object val, String bdKey) {
        Object taxItemId = 0L;
        try {
            val = new BigDecimal(String.valueOf(val));
        }
        catch (NumberFormatException e) {
            return taxItemId;
        }
        QFilter filter = new QFilter("taxrate", "=", val);
        DynamicObject obj = QueryServiceHelper.queryOne((String)bdKey, (String)"id", (QFilter[])new QFilter[]{filter});
        if (null != obj) {
            taxItemId = obj.get("id");
        }
        return taxItemId;
    }

    private List<String> getIsImportPros() {
        if (null != this.isImportProsList) {
            return this.isImportProsList;
        }
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return null;
        }
        String entityKey = this.getView().getEntityId();
        DynamicObject parentObj = parentView.getModel().getDataEntity(true);
        this.isImportProsList = PdsCompConfigUtil.getPros((DynamicObject)parentObj, (String)entityKey, (String)this.getEntryKey(), (String)"isimport", (boolean)true);
        String unEditablePricePro = this.getUnEditablePriceProByTaxType();
        this.isImportProsList.remove(unEditablePricePro);
        if (this.isAdd()) {
            this.isImportProsList.add("isnew");
        }
        return this.isImportProsList;
    }

    public Map<String, String> getMustInputProMap() {
        if (null == this.mustInputProMap) {
            StringBuilder proKey;
            this.mustInputProMap = new HashMap<String, String>(1);
            IDataModel model = this.getModel();
            Object compConfigId = model.getValue("compconfigid");
            if (null != compConfigId && String.valueOf(compConfigId).trim().length() > 0) {
                this.mustInputProMap = PdsCompConfigUtil.getMustInputValByCompConfig((Object)compConfigId);
                proKey = new StringBuilder();
                proKey.append(this.getEntryKey());
                proKey.append('.');
                proKey.append(this.getUnEditablePriceProByTaxType());
                this.mustInputProMap.remove(proKey.toString());
            }
            if (this.isAdd()) {
                proKey = new StringBuilder();
                proKey.append(this.getEntryKey());
                proKey.append('.');
                proKey.append("materialnane");
                this.mustInputProMap.put(proKey.toString(), proKey.toString());
            }
        }
        return this.mustInputProMap;
    }

    private String getUnEditablePriceProByTaxType() {
        String taxType = this.getModel().getDataEntity().getString("taxtype");
        StringBuilder proKey = new StringBuilder();
        if ("2".equals(taxType)) {
            proKey.append("taxprice");
        } else {
            proKey.append("price");
        }
        return proKey.toString();
    }

    protected void afterImportOneRow(TableValueSetter ts, int rowIndex, boolean isUpdate) {
        super.afterImportOneRow(ts, rowIndex, isUpdate);
        if (isUpdate) {
            IDataModel model = this.getModel();
            Object discardBid = model.getValue("isdiscardbid", rowIndex);
            if (!((Boolean)discardBid).booleanValue()) {
                model.setValue("isdiscarded", (Object)0, rowIndex);
            } else {
                Object rowVal = model.getValue("isdiscarded", rowIndex);
                if (((Boolean)rowVal).booleanValue()) {
                    model.setValue("price", (Object)0, rowIndex);
                    model.setValue("taxitem", null, rowIndex);
                }
            }
        } else if (this.isAdd()) {
            Map<String, DynamicObject> purListIdColMap = this.getNotNewPurlistIdColMap();
            Object purlistId = ts.get("purlist", rowIndex);
            DynamicObject col = purListIdColMap.get(String.valueOf(purlistId));
            this.copyColVal(col, ts, rowIndex);
        }
        Object unitPk = ts.get("unit", rowIndex);
        Object qty = ts.get("qty", rowIndex);
        if (Objects.nonNull(unitPk) && Objects.nonNull(qty)) {
            ts.set("qty", (Object)this.setQtyScaleByUnit(unitPk, (BigDecimal)qty), rowIndex);
        }
    }

    private BigDecimal setQtyScaleByUnit(Object unitPk, BigDecimal qty) {
        DynamicObject unitObj = BusinessDataServiceHelper.loadSingle((Object)unitPk, (String)"bd_measureunits");
        if (Objects.isNull(unitObj)) {
            return qty;
        }
        return PdsCalculateUtils.setScaleByUnit((DynamicObject)unitObj, (BigDecimal)qty);
    }

    protected List<String> unVirtual() {
        ArrayList<String> unVirtualCols = new ArrayList<String>();
        unVirtualCols.add("project");
        unVirtualCols.add("purlist");
        unVirtualCols.add("material");
        unVirtualCols.add("taxitem");
        unVirtualCols.add("currency");
        return unVirtualCols;
    }

    public boolean isAdd() {
        boolean isAdd;
        String entityKey;
        IFormView parentView;
        boolean isAdd2;
        String userType = RequestContext.get().getUserType();
        return userType != null && userType.contains("3") ? (isAdd2 = this.getModel().getDataEntity().getBoolean("isadd")) : null != (parentView = this.getView().getParentView()) && ("tnd_quotebill".equals(entityKey = parentView.getEntityId()) || "tnd_tenderbill".equals(entityKey)) && (isAdd = this.getModel().getDataEntity().getBoolean("isadd"));
    }

    public boolean isImportRowAddNew(int index) {
        Map rowMap = (Map)this.dataRows.get(index);
        if (null != rowMap) {
            String val = (String)((Map)this.dataRows.get(index)).get(0);
            if (ResManager.loadKDString((String)"\u662f", (String)"SrcPurListImportEdit_7", (String)"scm-src-formplugin", (Object[])new Object[0]).equals(val)) {
                return true;
            }
        }
        return false;
    }

    public Map<String, DynamicObject> getNotNewPurlistIdColMap() {
        if (this.notNewPurListIdColMap.size() > 0) {
            return this.notNewPurListIdColMap;
        }
        DynamicObjectCollection cols = this.getModel().getEntryEntity(this.getEntryKey());
        for (DynamicObject col : cols) {
            boolean isNew = col.getBoolean("isnew");
            if (isNew) continue;
            DynamicObject purlist = col.getDynamicObject("purlist");
            this.notNewPurListIdColMap.put(String.valueOf(purlist.getPkValue()), col);
        }
        return this.notNewPurListIdColMap;
    }

    public void copyColVal(DynamicObject col, TableValueSetter ts, int rowIndex) {
        if (null != col) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.getEntryKey());
            if (null == entryGrid) {
                return;
            }
            List properties = DynamicObjectUtil.getContainerProperties((Container)entryGrid);
            properties.remove("isnew");
            properties.remove("material");
            properties.removeAll(this.isImportProsList);
            properties.remove("materialmodel");
            properties.remove("brand");
            for (String pro : properties) {
                IDataEntityProperty proPerty;
                if (Objects.equals("purlistseq", pro) || Objects.equals("suppliername", pro) || null == (proPerty = this.findPro(pro))) continue;
                Object obj = col.get(pro);
                if (obj instanceof DynamicObject) {
                    if ("packagename".equals(pro)) {
                        ts.set(pro, (Object)((DynamicObject)obj).getString("packagename"), rowIndex);
                        continue;
                    }
                    if ("compkey".equals(pro)) {
                        ts.set(pro, (Object)((DynamicObject)obj).getString("number"), rowIndex);
                        continue;
                    }
                    ts.set(pro, ((DynamicObject)obj).getPkValue(), rowIndex);
                    continue;
                }
                if (obj instanceof DynamicObjectCollection) {
                    ts.set(pro, (Object)PdsCommonUtils.cloneAttachment((DynamicObject)col, (String)pro), rowIndex);
                    continue;
                }
                try {
                    ts.set(pro, col.get(pro), rowIndex);
                }
                catch (Exception exception) {
                    BizLog.log((String)exception.getMessage());
                }
            }
        }
    }
}

