/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.src.common.util.SrcAppCache;
import kd.scm.src.common.util.SrcNegotiateUtil;
import kd.scm.src.formplugin.negotiate.SrcNegotiateFacade;

public class SrcPurListNegEdit
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        SrcAppCache.put((String)"src_negotiatebill", (Object)this.getView().getPageId(), (IFormView)this.getView().getParentView());
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        SrcNegotiateFacade.setDefaultValue(view, null);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        ExtPluginContext context = null;
        switch (operateKey) {
            case "autoaddnegbill": {
                context = SrcNegotiateFacade.prepareData(view, operateKey);
                if (!context.isSucced()) {
                    view.showMessage(ResManager.loadKDString((String)"\u6dfb\u52a0\u8bae\u4ef7\u5931\u8d25", (String)"SrcPurListNegEdit_14", (String)"scm-src-formplugin", (Object[])new Object[0]), context.getMessage().toString(), MessageTypes.Default);
                    args.setCancel(true);
                    break;
                }
            }
            case "addnegbill": {
                context = SrcNegotiateFacade.addNegBillVerify(view, operateKey);
                if (context.isSucced()) break;
                view.showMessage(ResManager.loadKDString((String)"\u6dfb\u52a0\u8bae\u4ef7\u5931\u8d25", (String)"SrcPurListNegEdit_14", (String)"scm-src-formplugin", (Object[])new Object[0]), context.getMessage().toString(), MessageTypes.Default);
                args.setCancel(true);
                break;
            }
            case "viewnegbill": {
                this.viewNegBillVerify(args);
                break;
            }
            case "save": 
            case "submit": {
                context = SrcNegotiateFacade.beforeSaveHandle(view, operateKey);
                if (context.isSucced()) break;
                view.showMessage(context.getMessage().toString());
                args.setCancel(true);
                break;
            }
        }
    }

    private void viewNegBillVerify(BeforeDoOperationEventArgs args) {
        DynamicObject negBill = SrcNegotiateUtil.getLastTurnsNegBill((IFormView)this.getView());
        if (null == negBill) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u8bae\u4ef7\u5355\u3002", (String)"SrcPurListNegEdit_13", (String)"scm-src-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "addnegbill": 
            case "autoaddnegbill": {
                if (!args.getOperationResult().isSuccess()) break;
                ExtPluginContext context = SrcNegotiateFacade.addNegBill(this.getView(), operateKey);
                this.getView().showMessage(context.getMessage().toString());
                break;
            }
            case "viewnegbill": {
                DynamicObject negBill;
                if (!args.getOperationResult().isSuccess() || !Objects.nonNull(negBill = SrcNegotiateUtil.getLastTurnsNegBill((IFormView)this.getView()))) break;
                Object billId = negBill.getPkValue();
                OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"src_negotiatebill", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
                break;
            }
        }
    }
}

