/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.scm.common.util.cal.ICal;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcCalImpl;

public class SrcPurlistTieredQuote
extends AbstractBillPlugIn {
    private ICal cal = new SrcCalImpl();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setTieredVisibleAndEditable();
        this.setCostDetailVisible();
    }

    private void setCostDetailVisible() {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        String entityId = parentView.getEntityId();
        if (Objects.equals("ide_formdesigner", entityId)) {
            return;
        }
        long sourceFlowId = PdsCommonUtils.getSourceFlowIdByCompView((IFormView)this.getView());
        Object isEnableObj = ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isEnableCostDetail", (Object)Boolean.FALSE, (long)PdsCommonUtils.getProjectIdByCompView((IFormView)this.getView()));
        boolean isEnableCostDetail = ExtParameterUtils.convertToBoolen((Object)isEnableObj);
        if (!isEnableCostDetail) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"costdetail"});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldName;
        super.propertyChanged(args);
        switch (fieldName = args.getProperty().getName()) {
            case "materialnane": {
                if (!"2".equals(PdsCommonUtils.getTieredTypeByCompView((IFormView)this.getView()))) break;
                this.setQtyFromDefaultValue(args.getProperty().getName(), args.getChangeSet()[0].getRowIndex(), "qtyfrom", "qtyto");
                break;
            }
            case "taxitem": {
                int currRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                DynamicObject entryRowObj = this.getModel().getEntryRowEntity("entryentity", currRowIndex);
                DynamicObjectCollection subCols = entryRowObj.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subCol : subCols) {
                    this.calcTieredPrice(entryRowObj, subCol);
                }
                this.getView().updateView("subentryentity");
                break;
            }
            case "tieredprice": 
            case "tieredtaxprice": {
                DynamicObject parentRowObj = this.getModel().getEntryRowEntity("entryentity", this.getModel().getEntryCurrentRowIndex("entryentity"));
                DynamicObjectCollection subEntryCols = parentRowObj.getDynamicObjectCollection("subentryentity");
                int subIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
                if (subEntryCols.size() < subIndex + 1) {
                    return;
                }
                DynamicObject subRowObj = this.getModel().getEntryRowEntity("subentryentity", subIndex);
                this.calcTieredPrice(parentRowObj, subRowObj);
                this.getView().updateView("subentryentity", this.getModel().getEntryCurrentRowIndex("subentryentity"));
                this.updateEntryPrice(parentRowObj, subRowObj);
                break;
            }
            case "tieredqtyfrom": 
            case "tieredqtyto": {
                this.updateEntryPriceByQty();
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs evt) {
        if ("3".equals(PdsCommonUtils.getTieredTypeByCompView((IFormView)this.getView()))) {
            this.setQtyFromDefaultValue(null, this.getModel().getEntryRowCount("subentryentity") - 1, "tieredqtyfrom", "tieredqtyto");
            this.setNewSubEntryDefaultValue();
        }
    }

    private void setQtyFromDefaultValue(String key, int index, String qtyFromField, String qtyToField) {
        if (index <= 0) {
            return;
        }
        if (null != key && !PdsCommonUtils.object2String((Object)this.getModel().getValue(key, index - 1), (String)"").equals(PdsCommonUtils.object2String((Object)this.getModel().getValue(key, index), (String)""))) {
            return;
        }
        this.getModel().setValue(qtyFromField, this.getModel().getValue(qtyToField, index - 1), index);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String opKey = ((AbstractOperate)evt.getSource()).getOperateKey();
        if (opKey.equals("save") || opKey.equals("submit")) {
            this.setSubEntryDefaultValue();
        }
    }

    private void setNewSubEntryDefaultValue() {
        DynamicObject parentRowObj = this.getModel().getEntryRowEntity("entryentity", this.getModel().getEntryCurrentRowIndex("entryentity"));
        int index = this.getModel().getEntryRowCount("subentryentity") - 1;
        if (index < 0) {
            return;
        }
        this.getModel().setValue("tieredunit", parentRowObj.get("unit"), index);
        this.getModel().setValue("tieredcurr", parentRowObj.get("currency"), index);
        this.getModel().setValue("tieredproject", (Object)PdsCommonUtils.getProjectIdByCompView((IFormView)this.getView()), index);
    }

    private void setSubEntryDefaultValue() {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        if (!"3".equals(PdsCommonUtils.getTieredTypeByCompView((IFormView)this.getView()))) {
            return;
        }
        DynamicObjectCollection parentRowObjs = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (int parentRow = 0; parentRow < parentRowObjs.size(); ++parentRow) {
            DynamicObject parentRowObj = (DynamicObject)parentRowObjs.get(parentRow);
            DynamicObjectCollection subRowObjs = parentRowObj.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subRowObj : subRowObjs) {
                subRowObj.set("tieredunit", parentRowObj.get("unit"));
                subRowObj.set("tieredcurr", parentRowObj.get("currency"));
                subRowObj.set("tieredproject", (Object)PdsCommonUtils.getProjectIdByCompView((IFormView)this.getView()));
                this.calcTieredPrice(parentRowObj, subRowObj);
            }
        }
    }

    private void calcTieredPrice(DynamicObject parentRowObj, DynamicObject subRowObj) {
        int pricePrecision = parentRowObj.getDynamicObject("currency").getInt("priceprecision");
        if (pricePrecision == 0) {
            pricePrecision = 6;
        }
        if ("2".equals(PdsCommonUtils.getTaxTypeByCompView((IFormView)this.getView()))) {
            subRowObj.set("tieredtaxprice", (Object)subRowObj.getBigDecimal("tieredprice").multiply(this.getTaxRate(parentRowObj)));
        } else {
            subRowObj.set("tieredprice", (Object)subRowObj.getBigDecimal("tieredtaxprice").divide(this.getTaxRate(parentRowObj), pricePrecision, RoundingMode.HALF_DOWN));
        }
    }

    private void updateEntryPrice(DynamicObject parentRowObj, DynamicObject subRowObj) {
        BigDecimal qty = parentRowObj.getBigDecimal("qty");
        if (qty.compareTo(subRowObj.getBigDecimal("tieredqtyfrom")) > 0 && qty.compareTo(subRowObj.getBigDecimal("tieredqtyto")) <= 0) {
            String fieldKey = null;
            if ("2".equals(PdsCommonUtils.getTaxTypeByCompView((IFormView)this.getView()))) {
                parentRowObj.set("price", (Object)subRowObj.getBigDecimal("tieredprice"));
                fieldKey = "price";
            } else {
                parentRowObj.set("taxprice", (Object)subRowObj.getBigDecimal("tieredtaxprice"));
                fieldKey = "taxprice";
            }
            this.cal.proChanged(this.getModel(), "entryentity", fieldKey);
            this.getView().updateView("entryentity", this.getModel().getEntryCurrentRowIndex("entryentity"));
        }
    }

    private void updateEntryPriceByQty() {
        DynamicObject parentRowObj = this.getModel().getEntryRowEntity("entryentity", this.getModel().getEntryCurrentRowIndex("entryentity"));
        DynamicObjectCollection subEntryCols = parentRowObj.getDynamicObjectCollection("subentryentity");
        int subIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
        if (subEntryCols.size() < subIndex + 1) {
            return;
        }
        DynamicObject subRowObj = this.getModel().getEntryRowEntity("subentryentity", subIndex);
        BigDecimal priceValue = BigDecimal.ZERO;
        priceValue = "2".equals(PdsCommonUtils.getTaxTypeByCompView((IFormView)this.getView())) ? subRowObj.getBigDecimal("tieredprice") : subRowObj.getBigDecimal("tieredtaxprice");
        if (priceValue.compareTo(BigDecimal.ZERO) > 0) {
            this.updateEntryPrice(parentRowObj, subRowObj);
        }
    }

    private BigDecimal getTaxRate(DynamicObject parentRowObj) {
        BigDecimal taxRate = parentRowObj.getBigDecimal("taxrate");
        if (taxRate.compareTo(BigDecimal.ZERO) <= 0) {
            return BigDecimal.ONE;
        }
        return BigDecimal.ONE.add(taxRate.divide(new BigDecimal("100")));
    }

    private void setTieredVisibleAndEditable() {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        if (Objects.equals("ide_formdesigner", parentView.getEntityId())) {
            return;
        }
        String tieredType = PdsCommonUtils.getTieredTypeByCompView((IFormView)this.getView());
        if (StringUtils.isBlank((CharSequence)tieredType) || "1".equals(tieredType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tieredadvconap", "qtyfrom", "qtyto"});
            return;
        }
        if ("2".equals(tieredType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tieredadvconap"});
            return;
        }
        if ("3".equals(tieredType)) {
            this.isSupplierSetTieredQty();
            this.getView().setVisible(Boolean.FALSE, new String[]{"qtyfrom", "qtyto"});
            DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
            if (null == rows || rows.size() == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"tieredadvconap"});
                return;
            }
        }
    }

    private void isSupplierSetTieredQty() {
        String pEntityKey = this.getView().getParentView().getEntityId();
        if ("tnd_tenderbill".equals(pEntityKey) || "tnd_quotebill".equals(pEntityKey)) {
            boolean isSupplierSetTieredQty = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)PdsCommonUtils.getSourceFlowIdByCompView((IFormView)this.getView()), (String)"isSupplierSetTieredQty", (Object)false, (long)PdsCommonUtils.getProjectIdByCompView((IFormView)this.getView())));
            if (isSupplierSetTieredQty) {
                this.getView().setEnable(Boolean.TRUE, -1, new String[]{"tieredqtyfrom", "tieredqtyto"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"newentrysub", "deleteentrysub"});
            } else {
                this.getView().setEnable(Boolean.FALSE, -1, new String[]{"tieredqtyfrom", "tieredqtyto"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"newentrysub", "deleteentrysub"});
            }
        }
    }
}

