/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.ext;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.scm.pds.common.extplugin.IExtendPlugin;
import kd.scm.src.common.contract.SrcContractUtils;

public class SrcContractToXhOrderValidator
implements IExtendPlugin {
    private static final long serialVersionUID = 1L;

    public void validate(IFormView view, BeforeDoOperationEventArgs args, DynamicObjectCollection rows, Boolean isFAJB) {
        String potentialSupplierIndex;
        long org;
        String notExistsMaterialPurchaseInfos;
        if (null == view) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        this.validReqsource(rows, sb);
        if (sb.length() > 0) {
            view.showTipNotification(sb.toString());
            args.setCancel(true);
            return;
        }
        String emptyMaterialIndex = SrcContractUtils.getEmptyMaterialIndex((DynamicObjectCollection)rows);
        String emptyExrateIndex = this.getEmptyExrateIndex(rows);
        String excessIndex = "";
        if (!isFAJB.booleanValue()) {
            excessIndex = this.getExcessIndex(rows);
        }
        if (excessIndex.length() != 0) {
            sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5173\u8054\u8ba2\u5355\u6570\u91cf\u5927\u4e8e\u7b49\u4e8e\u6570\u91cf\uff0c\u65e0\u6cd5\u4e0b\u63a8\u91c7\u8d2d\u8ba2\u5355\u3002", (String)"SrcContractToXhOrderValidator_4", (String)"scm-src-formplugin", (Object[])new Object[0]), excessIndex)).append('\n');
        }
        if (emptyMaterialIndex.length() != 0) {
            sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7269\u6599\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8\u91c7\u8d2d\u8ba2\u5355\u3002", (String)"SrcContractToXhOrderValidator_0", (String)"scm-src-formplugin", (Object[])new Object[0]), emptyMaterialIndex)).append('\n');
        }
        if (emptyExrateIndex.length() != 0) {
            sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u6c47\u7387\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8\u91c7\u8d2d\u8ba2\u5355\u3002", (String)"SrcContractToXhOrderValidator_5", (String)"scm-src-formplugin", (Object[])new Object[0]), emptyExrateIndex)).append('\n');
        }
        if ((notExistsMaterialPurchaseInfos = SrcContractUtils.isExistsMaterialPurchaseInfoByEdit((DynamicObjectCollection)rows, (long)(org = view.getModel().getDataEntity().getLong("org_id")))).length() != 0) {
            sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7269\u6599\u4e0d\u5b58\u5728\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\uff0c\u8bf7\u5148\u7ef4\u62a4\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u3002", (String)"SrcContractToXhOrderValidator_1", (String)"scm-src-formplugin", (Object[])new Object[0]), notExistsMaterialPurchaseInfos)).append('\n');
        }
        if ((potentialSupplierIndex = SrcContractUtils.getPotentialSupplierIndex((DynamicObjectCollection)rows, (StringBuilder)sb)).length() != 0) {
            sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4f9b\u5e94\u5546\u4e3a\u6f5c\u5728\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8\u91c7\u8d2d\u8ba2\u5355\u3002", (String)"SrcContractToXhOrderValidator_2", (String)"scm-src-formplugin", (Object[])new Object[0]), potentialSupplierIndex)).append('\n');
        }
        if (sb.length() > 0) {
            view.showTipNotification(sb.toString());
            args.setCancel(true);
        }
    }

    private void validReqsource(DynamicObjectCollection rows, StringBuilder stringBuilder) {
        HashSet<String> sourceSet = new HashSet<String>();
        for (DynamicObject row : rows) {
            String resource = row.getString("reqsource");
            sourceSet.add(resource);
            if (sourceSet.size() <= 1) continue;
            stringBuilder.append(ResManager.loadKDString((String)"\u4e0a\u6e38\u6e90\u5355\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u4e0b\u63a8\u91c7\u8d2d\u8ba2\u5355\u3002", (String)"SrcContractToXhOrderValidator_3", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private String getExcessIndex(DynamicObjectCollection rows) {
        List excessList = rows.stream().filter(e -> e.getBigDecimal("orderqty").compareTo(e.getBigDecimal("qty")) >= 0).collect(Collectors.toList());
        if (excessList.size() == 0) {
            return "";
        }
        Set materialIdSet = excessList.stream().map(e -> e.getInt("seq")).collect(Collectors.toSet());
        return materialIdSet.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    private String getEmptyExrateIndex(DynamicObjectCollection rows) {
        List emptyExrateList = rows.stream().filter(e -> e.getBigDecimal("exrate") == null || BigDecimal.ZERO.compareTo(e.getBigDecimal("exrate")) == 0).collect(Collectors.toList());
        if (emptyExrateList.size() == 0) {
            return "";
        }
        Set emptyExrateIndexSet = emptyExrateList.stream().map(e -> e.getInt("seq")).collect(Collectors.toSet());
        return emptyExrateIndexSet.stream().map(String::valueOf).collect(Collectors.joining(","));
    }
}

