/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.list;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.mytask.SrcMyTaskFacade;
import kd.scm.pds.common.util.ListSelectUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcMyTaskHandler
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String opKey = ((AbstractOperate)evt.getSource()).getOperateKey();
        if (opKey.equals("refresh") || opKey.equals("close") || opKey.equals("modify")) {
            return;
        }
        evt.setCancel(true);
        Set selectIds = ListSelectUtils.getListSelectPrimaryKeys((IFormView)this.getView());
        SrcMyTaskContext context = new SrcMyTaskContext();
        context.setCurrView(this.getView());
        context.setSelectIds(selectIds);
        switch (opKey) {
            case "clarify": {
                this.clarifyVerify(context);
                break;
            }
            case "signin": {
                this.signinVerify(context);
                break;
            }
            case "handle": {
                this.scoreVerify(context);
                break;
            }
            case "entrust": {
                this.entrustVerify(context);
                break;
            }
            case "terminate": {
                this.terminateVerify(context);
                break;
            }
            case "reupdate": {
                this.reUpdateUsers(context);
                break;
            }
            case "encrypt": {
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"pds_encryptdetail", (ShowType)ShowType.MainNewTabPage, null, (QFilter)this.getProjectQFilter(evt.getListSelectedData().get(0).getPrimaryKeyValue()), null);
                break;
            }
            case "encrypttask": {
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"pds_encryptdetail", (ShowType)ShowType.MainNewTabPage, null, null, null);
                break;
            }
            case "bidopen": {
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"pds_bidopendetail", (ShowType)ShowType.MainNewTabPage, null, (QFilter)this.getProjectQFilter(evt.getListSelectedData().get(0).getPrimaryKeyValue()), null);
                break;
            }
            case "bidopentask": {
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"pds_bidopendetail", (ShowType)ShowType.MainNewTabPage, null, null, null);
                break;
            }
            case "supencrypttask": {
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"pds_supencryptdetail", (ShowType)ShowType.MainNewTabPage, null, null, null);
                break;
            }
            case "scoreanalyse": {
                this.openScoreAnalyse(null);
                break;
            }
            case "aptitudeanalyse": {
                this.openScoreAnalyse("4");
                break;
            }
            case "aptitudeanalyse2": {
                this.openScoreAnalyse("7");
                break;
            }
            case "notify": {
                this.notifyVerify(context);
                break;
            }
        }
    }

    private void openScoreAnalyse(String baseType) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        DynamicObject[] mytaskObjs = SrcMyTaskFacade.getSelectMytaskObjs((IFormView)this.getView());
        if (null != mytaskObjs && mytaskObjs.length > 0) {
            Set baseTypeSet = SrcMyTaskFacade.getSelectBizTypeSet((DynamicObject[])mytaskObjs);
            Set projectIdSet = SrcMyTaskFacade.getSelectProjectIds((DynamicObject[])mytaskObjs);
            paramMap.put("basetype", baseTypeSet);
            paramMap.put("projectids", projectIdSet);
        } else {
            paramMap.put("basetype", baseType);
        }
        OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_scoreanalyse", (ShowType)ShowType.MainNewTabPage, paramMap, null, null);
    }

    public void packageData(PackageDataEvent e) {
        if (e.getSource() instanceof ListOperationColumnDesc && "taskhandleop".equals(((ListOperationColumnDesc)e.getSource()).getKey())) {
            Set todoTaskSet = SrcMyTaskFacade.getTodoTaskSet((DynamicObject)e.getRowData());
            List operationColItems = (List)e.getFormatValue();
            for (OperationColItem operationColItem : operationColItems) {
                if (null != todoTaskSet && todoTaskSet.contains(operationColItem.getOperationKey())) {
                    operationColItem.setVisible(true);
                    continue;
                }
                operationColItem.setVisible(false);
            }
        }
        super.packageData(e);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String key;
        super.closedCallBack(evt);
        switch (key = evt.getActionId()) {
            case "clarify": 
            case "entrust": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        if (MessageBoxResult.Cancel.getValue() == evt.getResult().getValue()) {
            return;
        }
        switch (key = evt.getCallBackId()) {
            case "signin": {
                this.signinHandle();
                break;
            }
            case "terminate": {
                this.terminateHandle();
                break;
            }
            case "notify": {
                this.notifyHandle();
                break;
            }
        }
    }

    protected void clarifyVerify(SrcMyTaskContext context) {
        SrcMyTaskFacade.clarifyVerify((SrcMyTaskContext)context);
        if (context.isVerifyOk()) {
            HashMap<String, Set> handleIdMap = new HashMap<String, Set>(1);
            handleIdMap.put("id", context.getHandleIds());
            OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"pds_benefitclarify", (ShowType)ShowType.Modal, handleIdMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "clarify"));
        } else {
            this.getView().showMessage(context.getVerifyMessage());
        }
    }

    protected void entrustVerify(SrcMyTaskContext context) {
        SrcMyTaskFacade.entrustVerify((SrcMyTaskContext)context);
        if (context.isVerifyOk()) {
            HashMap<String, Set> handleIdMap = new HashMap<String, Set>(1);
            handleIdMap.put("id", context.getHandleIds());
            OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"pds_entrust", (ShowType)ShowType.Modal, handleIdMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "entrust"));
        } else {
            this.getView().showMessage(context.getVerifyMessage());
        }
    }

    protected void scoreVerify(SrcMyTaskContext context) {
        SrcMyTaskFacade.scoreVerify((SrcMyTaskContext)context);
        if (context.isVerifyOk()) {
            SrcMyTaskFacade.scoreHandle((SrcMyTaskContext)context);
        } else {
            this.getPageCache().put("handle", null);
            this.getView().showMessage(context.getVerifyMessage());
        }
    }

    protected void signinVerify(SrcMyTaskContext context) {
        SrcMyTaskFacade.SigninVerify((SrcMyTaskContext)context);
        if (context.isVerifyOk()) {
            this.getPageCache().put("signin", SerializationUtils.toJsonString((Object)context.getHandleIds()));
            this.getView().showConfirm(context.getVerifyMessage(), MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("signin"));
        } else {
            this.getPageCache().put("signin", null);
            this.getView().showMessage(context.getVerifyMessage());
        }
    }

    protected void notifyVerify(SrcMyTaskContext context) {
        SrcMyTaskFacade.notifyVerify((SrcMyTaskContext)context);
        if (context.isVerifyOk()) {
            this.getPageCache().put("notify", SerializationUtils.toJsonString((Object)context.getHandleIds()));
            this.getView().showConfirm(context.getVerifyMessage(), MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("notify"));
        } else {
            this.getPageCache().put("notify", null);
            this.getView().showMessage(context.getVerifyMessage());
        }
    }

    protected void signinHandle() {
        if (this.getPageCache().get("signin") != null) {
            SrcMyTaskContext context = new SrcMyTaskContext();
            Set handleIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("signin"), HashSet.class);
            context.setHandleIds(handleIds);
            SrcMyTaskFacade.signinHandle((SrcMyTaskContext)context);
            this.getView().showMessage(context.getHandleMessage());
            this.getView().invokeOperation("refresh");
        }
    }

    protected void notifyHandle() {
        if (this.getPageCache().get("notify") != null) {
            SrcMyTaskContext context = new SrcMyTaskContext();
            Set handleIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("notify"), HashSet.class);
            context.setHandleIds(handleIds);
            SrcMyTaskFacade.notifyHandle((SrcMyTaskContext)context);
            this.getView().showMessage(context.getHandleMessage());
            this.getView().invokeOperation("refresh");
        }
    }

    protected void terminateVerify(SrcMyTaskContext context) {
        SrcMyTaskFacade.terminateVerify((SrcMyTaskContext)context);
        if (context.isVerifyOk()) {
            this.getPageCache().put("terminate", SerializationUtils.toJsonString((Object)context.getHandleIds()));
            this.getView().showConfirm(context.getVerifyMessage(), MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("terminate"));
        } else {
            this.getPageCache().put("terminate", null);
            this.getView().showMessage(context.getVerifyMessage());
        }
    }

    protected void terminateHandle() {
        if (this.getPageCache().get("terminate") != null) {
            SrcMyTaskContext context = new SrcMyTaskContext();
            Set handleIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("terminate"), HashSet.class);
            context.setHandleIds(handleIds);
            SrcMyTaskFacade.terminateHandle((SrcMyTaskContext)context);
            this.getView().showMessage(context.getHandleMessage());
            this.getView().invokeOperation("refresh");
        }
    }

    protected void reUpdateUsers(SrcMyTaskContext context) {
        if (context.getSelectIds() == null || context.getSelectIds().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u4efb\u52a1\u8fdb\u884c\u91cd\u7f6e\u3002", (String)"SrcMyTaskHandler_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] myTaskObjs = SrcMyTaskFacade.getMyTaskByHandleIds((Set)context.getSelectIds());
        Map<Long, List<DynamicObject>> maTaskMap = Arrays.asList(myTaskObjs).stream().collect(Collectors.groupingBy(e -> e.getLong("project.id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : maTaskMap.entrySet()) {
            DynamicObjectCollection rows = new DynamicObjectCollection();
            rows.addAll((Collection)entry.getValue());
            SrcMyTaskFacade.setBizRoleUsers((long)entry.getKey(), (DynamicObjectCollection)rows);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])myTaskObjs);
        this.getView().invokeOperation("refresh");
    }

    private QFilter getProjectQFilter(Object entryId) {
        QFilter qFilter = new QFilter("id", "=", (Object)PdsCommonUtils.object2Long((Object)entryId));
        DynamicObject row = QueryServiceHelper.queryOne((String)"src_memberclarify", (String)"project.id", (QFilter[])qFilter.toArray());
        long projectId = 0L;
        if (null != row) {
            projectId = row.getLong("project.id");
        }
        return new QFilter("project", "=", (Object)projectId);
    }
}

