/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.list;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.BillList;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.feemanage.FeeManageUtils;

public class SrcPaymentList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter qFilter = new QFilter("project.id", ">", (Object)0L);
        qFilters.add(qFilter);
    }

    public void packageData(PackageDataEvent e) {
        if (e.getSource() instanceof ListOperationColumnDesc && "taskhandleop".equals(((ListOperationColumnDesc)e.getSource()).getKey())) {
            List operationColItems = (List)e.getFormatValue();
            for (OperationColItem operationColItem : operationColItems) {
                boolean isVisible = FeeManageUtils.isButtonVisible((String)operationColItem.getOperationKey(), (String)e.getRowData().getString("paystatus"));
                operationColItem.setVisible(isVisible);
            }
        }
        super.packageData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        switch (opKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "confirm": 
            case "reject": 
            case "exempt": 
            case "return": 
            case "transfer": 
            case "carryover": {
                this.paymentHandle(opKey);
                args.setCancel(true);
                break;
            }
        }
    }

    private void paymentHandle(String opKey) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if (objects == null || objects.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u80fd\u5904\u7406\u4e00\u7b14\u4e1a\u52a1\uff0c\u8bf7\u9009\u62e9\u4e00\u7b14\u4e1a\u52a1\u3002", (String)"SrcPaymentList_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return;
        }
        long entryId = (Long)objects[0];
        DynamicObject paymentObj = BusinessDataServiceHelper.loadSingle((Object)entryId, (String)"src_payment");
        if (null == paymentObj) {
            return;
        }
        if (!FeeManageUtils.verifyPayStatus((String)opKey, (DynamicObject)paymentObj, (IFormView)this.getView())) {
            return;
        }
        FeeManageUtils.openPaymentHandlePage((String)opKey, (DynamicObject)paymentObj, (IFormView)this.getView());
    }
}

