/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.list;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.util.ListSelectUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.score.SrcScoreFacade;

public class SrcScoreAnalyseList
extends AbstractListPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String baseType = PdsCommonUtils.object2String(showParameter.getCustomParams().get("basetype"), (String)"");
        if ("4".equals(baseType)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u8d44\u8d28\u9884\u5ba1\u5206\u6790", (String)"SrcScoreAnalyseList_2", (String)"scm-src-formplugin", (Object[])new Object[0]));
        } else if ("7".equals(baseType)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u8d44\u8d28\u540e\u5ba1\u5206\u6790", (String)"SrcScoreAnalyseList_3", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        switch (opKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "return": {
                this.scoreReturn(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (null != result && !result.isSuccess()) {
            return;
        }
        HashMap<String, Long> paramMap = this.getView().getFormShowParameter().getCustomParams();
        if (null == paramMap) {
            paramMap = new HashMap<String, Long>();
        }
        switch (operateKey) {
            case "scorehelper": {
                long projectId = ListSelectUtils.selectOneFromScorerF7((IFormView)this.getView());
                if (projectId > 0L) {
                    paramMap.put("project", projectId);
                }
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_scoreassist", (ShowType)ShowType.MainNewTabPage, paramMap, null);
                break;
            }
            case "scoretask": {
                String baseType;
                long projectId = ListSelectUtils.selectOneFromScorerF7((IFormView)this.getView());
                QFilter qFilter = null;
                if (projectId > 0L) {
                    qFilter = new QFilter("id", "=", (Object)projectId);
                }
                if ("4".equals(baseType = PdsCommonUtils.object2String(paramMap.get("basetype"), (String)"5")) || "7".equals(baseType)) {
                    OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_aptitudeaudit", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qFilter, null);
                    break;
                }
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_scorertask", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qFilter, null);
                break;
            }
        }
    }

    private void scoreReturn(BeforeDoOperationEventArgs args) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        SrcScoreFacade.scoreReturn((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (Object[])objects);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columnList = args.getListColumns();
        ArrayList<String> fieldList = new ArrayList<String>(columnList.size());
        for (int i = 0; i < columnList.size(); ++i) {
            fieldList.add(((IListColumn)columnList.get(i)).toString().replace('.', '_'));
        }
        SrcScoreAnalyseList.getCache().put("fieldname", (Object)SerializationUtils.toJsonString(fieldList));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    public static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(RequestContext.get().getTenantId() + "_" + "src");
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            for (DynamicObject row2 : rows) {
                boolean ishidesupplier = row2.getBoolean("project.ishidesupplier");
                if (ishidesupplier) {
                    row2.set("supplier", row2.get("billid.suppliercode"));
                    continue;
                }
                row2.set("supplier", row2.get("billid.supplier.name"));
            }
            Function<DynamicObject, String> function = row -> row.getString("entryid.id");
            List sList = rows.stream().sorted(Comparator.comparing(function).thenComparing(row -> row.getString("billid.id")).thenComparing(row -> row.getString("project.id"))).collect(Collectors.toList());
            boolean isSetColor = false;
            String preKey = null;
            HashSet<String> pkSet = new HashSet<String>();
            for (DynamicObject row3 : sList) {
                String key = row3.getString("project.id") + "|" + row3.getString("billid.id") + "|" + row3.getLong("entryid.id");
                if (preKey == null) {
                    preKey = key;
                }
                if (!StringUtils.equals((CharSequence)key, (CharSequence)preKey)) {
                    isSetColor = !isSetColor;
                    preKey = key;
                }
                if (!isSetColor) continue;
                pkSet.add(String.valueOf(row3.getPkValue()));
            }
            SrcScoreAnalyseList.getCache().put("entryid", (Object)SerializationUtils.toJsonString(pkSet));
            return rows;
        }
    }
}

