/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.pricecfm;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.src.formplugin.pricecfm.ISrcPriceHandler;
import kd.scm.src.formplugin.pricecfm.SrcPriceContext;

public class SrcPriceConfirmGetFromLib
implements ISrcPriceHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcPriceContext context) {
        QFilter qfilters = new QFilter("supplier", "=", (Object)context.getSupplierId());
        List orgIds = context.getPurlistList().stream().map(e -> e.getLong("org.id")).collect(Collectors.toList());
        orgIds.add(context.getOrgId());
        qfilters.and("org", "in", orgIds);
        List materialIds = context.getPurlistList().stream().map(e -> e.getLong("material.id")).collect(Collectors.toList());
        qfilters.and("material", "in", materialIds);
        List currencyIds = context.getPurlistList().stream().map(e -> e.getLong("currency.id")).collect(Collectors.toList());
        qfilters.and("currency", "in", currencyIds);
        qfilters.and("entrystatus", "in", this.getProjectStatus());
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_pricelib", (boolean)true);
        DynamicObjectCollection materialObjs = QueryServiceHelper.query((String)"src_pricelib", (String)selectFields, (QFilter[])qfilters.toArray(), (String)"org,material,currency,project.billdate desc");
        Map<String, DynamicObject> materialMap = materialObjs.stream().collect(Collectors.groupingBy(e -> e.getString("org") + '|' + e.getString("material") + '|' + e.getString("currency"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        int updateCount = 0;
        for (DynamicObject purlistObj : context.getPurlistList()) {
            String orgId = purlistObj.getString("org.id");
            if (null == orgId || "0".equals(orgId)) {
                orgId = String.valueOf(context.getOrgId());
            }
            String materialId = purlistObj.getString("material.id");
            String currencyId = purlistObj.getString("currency.id");
            String key = orgId + '|' + materialId + '|' + currencyId;
            DynamicObject materialObj = materialMap.get(key);
            if (null == materialObj) continue;
            purlistObj.set("price", materialObj.get("price"));
            purlistObj.set("taxprice", materialObj.get("taxprice"));
            purlistObj.set("taxitem", materialObj.get("taxitem"));
            purlistObj.set("taxrate", materialObj.get("taxrate"));
            ++updateCount;
        }
        context.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6709 %1$s \u884c\u7269\u6599\u53d6\u4ef7\u6210\u529f, %2$s \u884c\u7269\u6599\u672a\u53d6\u5230\u4ef7\u683c\u3002", (String)"SrcPriceConfirmGetFromLib_1", (String)"scm-src-formplugin", (Object[])new Object[0]), updateCount, context.getPurlistList().size() - updateCount));
    }

    private Set<String> getProjectStatus() {
        HashSet<String> projectStatusSet = new HashSet<String>();
        projectStatusSet.add(ProjectStatusEnums.OPENED.getValue());
        projectStatusSet.add(ProjectStatusEnums.SIGNED.getValue());
        return projectStatusSet;
    }
}

