/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.vie;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.PayStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcWinruleUtils;
import kd.scm.src.formplugin.vie.ISrcBidStartVerifier;

public class SrcBidStartVerifierPaidSupplierNum
implements ISrcBidStartVerifier {
    private static final long serialVersionUID = 1L;

    @Override
    public String verify(long projectId) {
        QFilter qfilters = new QFilter("id", "=", (Object)projectId);
        DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_projectf7", (String)"feeway.number,feeitem.id,managetype", (QFilter[])qfilters.toArray());
        String feeway = projectObj.getString("feeway.number");
        String feeitem = projectObj.getString("feeitem.id");
        if (null == feeway || "C020701".equals(feeway)) {
            return "succed";
        }
        if (null == feeitem || "775219867547625472".equals(feeitem)) {
            return "succed";
        }
        Map winruleSupQtyMap = SrcWinruleUtils.getWinruleWinerQtyMap((long)projectId);
        Map<String, Integer> paidSupQtyMap = this.getPaidSupQtyMap(projectId);
        StringBuilder message = new StringBuilder();
        for (Map.Entry<String, Integer> entry : paidSupQtyMap.entrySet()) {
            String manageType;
            String[] keys = entry.getKey().split("\\|");
            long packageId = PdsCommonUtils.object2Long((Object)keys[0]);
            int winRuleSupQty = this.getWinerQty(winruleSupQtyMap, projectId, packageId);
            int paidSupQty = entry.getValue();
            if (winRuleSupQty <= 0 || winRuleSupQty <= paidSupQty) continue;
            if (message.length() > 0) {
                message.append("\n");
            }
            if ("2".equals(manageType = projectObj.getString("managetype"))) {
                String packageName = keys[1];
                message.append(String.format(ResManager.loadKDString((String)"\u6807\u6bb5(%s)", (String)"SrcBidStartVerifierPaidSupplierNum_8", (String)"scm-src-formplugin", (Object[])new Object[0]), packageName));
            } else {
                message.append(ResManager.loadKDString((String)"\u8be5\u9879\u76ee", (String)"SrcBidStartVerifierPaidSupplierNum_6", (String)"scm-src-formplugin", (Object[])new Object[0]));
            }
            message.append(String.format(ResManager.loadKDString((String)"\u5df2\u7f34\u8d39\u4f9b\u5e94\u5546\u6570\u91cf(%1$s), \u5c0f\u4e8e\u4e2d\u6807\u539f\u5219\u7684\u4e2d\u6807\u4f9b\u5e94\u5546\u6570\u91cf(%2$s)\u3002", (String)"SrcBidStartVerifierPaidSupplierNum_7", (String)"scm-src-formplugin", (Object[])new Object[0]), paidSupQty, winRuleSupQty));
        }
        if (message.length() > 0) {
            return message.toString();
        }
        return "succed";
    }

    private int getWinerQty(Map<Long, Integer> winruleSupQtyMap, long projectId, long packageId) {
        if (null != winruleSupQtyMap.get(packageId) && winruleSupQtyMap.get(packageId) > 0) {
            return winruleSupQtyMap.get(packageId);
        }
        return winruleSupQtyMap.get(projectId);
    }

    private Map<String, Integer> getPaidSupQtyMap(long projectId) {
        DynamicObject[] pkgRows = PdsCommonUtils.loadBillObjsByQFilter((String)"src_packagef7", (QFilter)new QFilter("project", "=", (Object)projectId));
        HashMap<String, Integer> paidSupQtyMap = new HashMap<String, Integer>(pkgRows.length);
        for (DynamicObject pkgRow : pkgRows) {
            String key = String.valueOf(pkgRow.getLong("package.id")) + '|' + pkgRow.getString("package.packagename");
            paidSupQtyMap.put(key, 0);
        }
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and(new QFilter("paystatus", "=", (Object)PayStatusEnums.CONFIRMED.getValue()).or("paystatus", "=", (Object)PayStatusEnums.EXEMPT.getValue()));
        qfilters.and("packfeeitem", "=", (Object)Long.parseLong("775220031326809088"));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_payment", (String)"feeway.number,package.id,package.packagename,supplier.id,paystatus", (QFilter[])qfilters.toArray());
        if (rows.size() == 0) {
            return paidSupQtyMap;
        }
        Map<Long, List<DynamicObject>> supplierGroup = rows.stream().collect(Collectors.groupingBy(e -> e.getLong("supplier.id")));
        boolean isByPackage = ((DynamicObject)rows.get(0)).getString("feeway.number").equals("C020703");
        Map<Long, List<DynamicObject>> paylistGroup = rows.stream().collect(Collectors.groupingBy(e -> e.getLong("package.id")));
        for (DynamicObject pkgRow : pkgRows) {
            String key = String.valueOf(pkgRow.getLong("package.id")) + '|' + pkgRow.getString("package.packagename");
            if (isByPackage) {
                List<DynamicObject> payList = paylistGroup.get(pkgRow.getLong("id"));
                if (null == payList) {
                    paidSupQtyMap.put(key, 0);
                    continue;
                }
                paidSupQtyMap.put(key, payList.size());
                continue;
            }
            paidSupQtyMap.put(key, supplierGroup.size());
        }
        return paidSupQtyMap;
    }
}

