/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.vie;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.src.formplugin.vie.ISrcBidStartVerifier;

public class SrcBidStartVerifierSupplierNum
implements ISrcBidStartVerifier {
    private static final long serialVersionUID = 1L;

    @Override
    public String verify(long projectId) {
        QFilter qfilters = new QFilter("id", "=", (Object)projectId);
        DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_projectf7", (String)"bidnumber,managetype", (QFilter[])qfilters.toArray());
        int bidNumber = projectObj.getInt("bidnumber");
        if (bidNumber <= 0) {
            return "succed";
        }
        StringBuilder message = new StringBuilder();
        DynamicObjectCollection supplierRows = this.getValidSupplierRows(projectId);
        if (supplierRows.size() == 0) {
            this.buildMessage(message, null, 0, bidNumber);
            return message.toString();
        }
        String manageType = projectObj.getString("managetype");
        if ("2".equals(manageType)) {
            this.verifybyPackage(this.getInveteSupplierRows(projectId), supplierRows, bidNumber, message);
        } else {
            this.verifybyProject(supplierRows, bidNumber, message);
        }
        if (message.length() > 0) {
            return message.toString();
        }
        return "succed";
    }

    private void verifybyProject(DynamicObjectCollection supplierRows, int bidNumber, StringBuilder message) {
        Map<Long, List<DynamicObject>> groupMap = supplierRows.stream().collect(Collectors.groupingBy(row -> row.getLong("supplier.id")));
        if (groupMap.size() < bidNumber) {
            this.buildMessage(message, null, groupMap.size(), bidNumber);
        }
    }

    private void verifybyPackage(DynamicObjectCollection inviteSupRows, DynamicObjectCollection supplierRows, int bidNumber, StringBuilder message) {
        Map<Long, List<DynamicObject>> confirmMap = supplierRows.stream().collect(Collectors.groupingBy(row -> row.getLong("package.id")));
        Map<Long, List<DynamicObject>> inviteMap = inviteSupRows.stream().collect(Collectors.groupingBy(row -> row.getLong("package.id")));
        inviteMap.forEach((key, value) -> {
            int cfmNumber = 0;
            List confirmList = (List)confirmMap.get(key);
            if (null != confirmList) {
                cfmNumber = confirmList.size();
            }
            String packageName = ((DynamicObject)value.get(0)).getString("package.packagename");
            if (cfmNumber < bidNumber) {
                this.buildMessage(message, packageName, cfmNumber, bidNumber);
            }
        });
    }

    private DynamicObjectCollection getValidSupplierRows(long projectId) {
        QFilter qfilters = SupplierUtil.getValidConfirmSupplierFilter((long)projectId, (long)0L);
        String selectProperties = "supplier.id,package.id,package.packagename";
        return QueryServiceHelper.query((String)"src_bidopensupplier", (String)selectProperties, (QFilter[])qfilters.toArray());
    }

    private DynamicObjectCollection getInveteSupplierRows(long projectId) {
        QFilter qfilters = SupplierUtil.getValidInviteSupplierFilter((long)projectId, (long)0L);
        String selectProperties = "supplier.id,package.id,package.packagename";
        return QueryServiceHelper.query((String)"src_bidopensupplier", (String)selectProperties, (QFilter[])qfilters.toArray());
    }

    private void buildMessage(StringBuilder message, String packageName, int cfmNumber, int bidNumber) {
        if (null == packageName) {
            message.append(String.format(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u6709\u6548\u5e94\u6807\u4f9b\u5e94\u5546\u6570(%1$s)\uff0c\u5c0f\u4e8e\u8981\u6c42\u7684\u4f9b\u5e94\u5546\u6570(%2$s)\u3002", (String)"SrcBidStartVerifierSupplierNum_2", (String)"scm-src-formplugin", (Object[])new Object[0]), cfmNumber, bidNumber));
        } else {
            message.append(String.format(ResManager.loadKDString((String)"\u6807\u6bb5(%1$s)\u6709\u6548\u5e94\u6807\u4f9b\u5e94\u5546\u6570(%2$s)\uff0c\u5c0f\u4e8e\u8981\u6c42\u7684\u4f9b\u5e94\u5546\u6570(%3$s)\u3002", (String)"SrcBidStartVerifierSupplierNum_3", (String)"scm-src-formplugin", (Object[])new Object[0]), packageName, cfmNumber, bidNumber));
        }
    }
}

