/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.vie;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.SrcVieStatusEnums;
import kd.scm.pds.common.util.ComboEditUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.vie.PdsVieHelper;

public class SrcVieAgainPlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setProjectId();
        this.setVieTurns();
        this.setTendencyScope();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String key = ((AbstractOperate)evt.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)"confirm", (CharSequence)key)) {
            Date turnsopendate = this.getModel().getDataEntity().getDate("turnsopendate");
            int turnsbidtime = this.getModel().getDataEntity().getInt("turnsbidtime");
            if (null != turnsopendate && 0 == turnsbidtime) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ade\u4ef7\u65f6\u957f(\u5206\u949f)\u4e0d\u80fd\u4e3a0\u3002", (String)"SrcVieAgainPlugin_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (evt.getOperateKey().equals("confirm") && evt.getOperationResult().isSuccess()) {
            PdsCommonUtils.refreshParentView((IFormView)this.getView());
            this.getView().close();
        }
    }

    private void setProjectId() {
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        long projectId = PdsCommonUtils.object2Long(paramMap.get("billid"));
        long srcbillId = PdsCommonUtils.object2Long(paramMap.get("srcbillid"));
        this.getModel().setValue("project", (Object)projectId);
        this.getModel().setValue("srcbillid", (Object)srcbillId);
    }

    private void setTendencyScope() {
        HashMap<String, String> comboMap = new HashMap<String, String>();
        if (this.getModel().getValue("vietype").equals("A")) {
            comboMap.put("1", ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u964d\u4ef7", (String)"SrcVieAgainPlugin_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
        } else {
            comboMap.put("2", ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u52a0\u4ef7", (String)"SrcVieAgainPlugin_2", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
        comboMap.put("3", ResManager.loadKDString((String)"\u5141\u8bb8\u52a0\u4ef7\u6216\u964d\u4ef7", (String)"SrcVieAgainPlugin_3", (String)"scm-src-formplugin", (Object[])new Object[0]));
        ComboEdit tendency = (ComboEdit)this.getControl("tendency");
        tendency.setComboItems(ComboEditUtils.getComboList(comboMap));
    }

    private void setVieTurns() {
        DynamicObject projectObj = this.getModel().getDataEntity().getDynamicObject("project");
        if (null == projectObj) {
            return;
        }
        String bidStatus = projectObj.getString("bidstatus");
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)projectObj);
        DynamicObject vieBillObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_competebill");
        Control control = this.getControl("fieldsetpanelap");
        List properties = DynamicObjectUtil.getContainerProperties((Container)((Container)control));
        PdsCommonUtils.copyDynamicObjectValue((DynamicObject)vieBillObj, (List)properties, Collections.emptySet(), (IDataModel)this.getModel(), (String)"", (String)"");
        DynamicObject turnsObj = PdsVieHelper.getLastVieTurnsObj((DynamicObject)vieBillObj, null);
        String turns = PdsVieHelper.getLastNegTurns((DynamicObject)PdsVieHelper.getLastNegTurnsObj((long)projectId));
        if (turns.equals("0")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"confirm"});
        }
        HashMap<String, Object> turnsMap = new HashMap<String, Object>(4);
        turnsMap.put("entryid", null);
        turnsMap.put("turnsopendate", null);
        turnsMap.put("turnsbidtime", null);
        turnsMap.put("turns", turns);
        if (null == turnsObj) {
            if (SrcVieStatusEnums.EVALUATING.getValue().equals(bidStatus) || SrcVieStatusEnums.CONFIRMED.getValue().equals(bidStatus)) {
                turnsMap.put("vieturns", "2");
                turnsMap.put("turnsbidstatus", SrcVieStatusEnums.BEENEXAMINED.getValue());
            } else {
                turnsMap.put("vieturns", "1");
                DynamicObject competeBillObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_competebill");
                turnsMap.put("turnsopendate", competeBillObj.getDate("opendate"));
                turnsMap.put("turnsbidtime", competeBillObj.getInt("bidtime"));
                turnsMap.put("turnsbidstatus", competeBillObj.getString("bidstatus"));
            }
        } else {
            bidStatus = turnsObj.getString("turnsbidstatus");
            String vieturns = turnsObj.getString("vieturns");
            turnsMap.put("entryid", turnsObj.get("id"));
            turnsMap.put("vieturns", turnsObj.getString("vieturns"));
            turnsMap.put("turnsopendate", turnsObj.getDate("turnsopendate"));
            turnsMap.put("turnsbidtime", turnsObj.getInt("turnsbidtime"));
            turnsMap.put("turnsbidstatus", bidStatus);
            switch (bidStatus) {
                case "B": {
                    break;
                }
                case "C": {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"turnsopendate", "turnsbidtime"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"confirm"});
                    break;
                }
                case "D": {
                    turnsMap.put("entryid", null);
                    turnsMap.put("vieturns", Integer.parseInt(vieturns) + 1);
                    turnsMap.put("turnsbidstatus", SrcVieStatusEnums.BEENEXAMINED.getValue());
                    turnsMap.put("turnsopendate", null);
                    turnsMap.put("turnsbidtime", null);
                    break;
                }
            }
        }
        this.setTurnsInfo(turnsMap);
    }

    private void setTurnsInfo(Map<String, Object> turnsMap) {
        this.getModel().setValue("entryid", turnsMap.get("entryid"));
        this.getModel().setValue("turns", turnsMap.get("turns"));
        this.getModel().setValue("vieturns", turnsMap.get("vieturns"));
        this.getModel().setValue("turnsopendate", turnsMap.get("turnsopendate"));
        this.getModel().setValue("turnsbidtime", turnsMap.get("turnsbidtime"));
        this.getModel().setValue("turnsbidstatus", turnsMap.get("turnsbidstatus"));
    }
}

