/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.vie;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.vie.PdsVieHelper;

public class SrcVieAgainRegionPlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.createEntryEntity();
        this.setVieRegionTitle();
    }

    private void createEntryEntity() {
        QFilter qfilter = this.getQFilter();
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"purlist.id", (QFilter[])qfilter.toArray(), (String)"purlist.id");
        if (rows.size() == 0) {
            return;
        }
        List purlistIds = rows.stream().map(e -> e.getLong("purlist.id")).distinct().collect(Collectors.toList());
        String valueField = PdsVieHelper.getVieValueField((String)this.getViePattern(), (String)this.getTaxType());
        String regionField = PdsVieHelper.getVieRegionField((String)this.getViePattern(), (String)this.getVieType());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        model.deleteEntryData("entryentity");
        Map<Long, List<DynamicObject>> purlistMap = this.getOptimalValue();
        Map<Long, DynamicObject> previousMap = this.getPreviousValue();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int index = 0;
        Iterator iterator = purlistIds.iterator();
        while (iterator.hasNext()) {
            long purlistId = (Long)iterator.next();
            ts.set("purlist", (Object)purlistId, index);
            List<DynamicObject> list = purlistMap.get(purlistId);
            DynamicObject previousObj = previousMap.get(purlistId);
            if (Objects.nonNull(list) && !list.isEmpty()) {
                if ("viefrom".equals(regionField)) {
                    ts.set(regionField, list.get(0).get(valueField), index);
                    if (null != previousObj) {
                        ts.set("vieto", previousObj.get("vieto"), index);
                    }
                } else {
                    ts.set(regionField, list.get(list.size() - 1).get(valueField), index);
                    if (null != previousObj) {
                        ts.set("viefrom", previousObj.get("viefrom"), index);
                    }
                }
            }
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private void setVieRegionTitle() {
        String viePattern = this.getModel().getDataEntity().getString("project.viepattern");
        String taxType = this.getModel().getDataEntity().getString("project.taxtype");
        Map viePatternTitleMap = PdsVieHelper.getViePatternTitle((String)viePattern, (String)taxType);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        HashMap map = new HashMap();
        map.put("zh_CN", viePatternTitleMap.get("viefrom"));
        entryGrid.setColumnProperty("viefrom", "header", map);
        map = new HashMap();
        map.put("zh_CN", viePatternTitleMap.get("vieto"));
        entryGrid.setColumnProperty("vieto", "header", map);
    }

    private Map<Long, List<DynamicObject>> getOptimalValue() {
        QFilter qfilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity().getDynamicObject("project")));
        List<String> statusList = Arrays.asList(ProjectStatusEnums.OPENED.getValue(), ProjectStatusEnums.CLOSED.getValue());
        qfilter.and("entrystatus", "in", statusList);
        qfilter.and("supplier", ">", (Object)0L);
        String selectFields = "id,suppliertype,supplier,purlist.id,price,taxprice,vieratio,viediffer";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)selectFields, (QFilter[])qfilter.toArray());
        if (rows.size() == 0) {
            return Collections.emptyMap();
        }
        String valueField = PdsVieHelper.getVieValueField((String)this.getViePattern(), (String)this.getTaxType());
        Map<Long, List<DynamicObject>> purlistMap = rows.stream().sorted(Comparator.comparing(e -> ((DynamicObject)e).getLong("purlist.id")).thenComparing(e -> ((DynamicObject)e).getBigDecimal(valueField))).collect(Collectors.groupingBy(e -> e.getLong("purlist.id")));
        return purlistMap;
    }

    private Map<Long, DynamicObject> getPreviousValue() {
        QFilter qfilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity().getDynamicObject("project")));
        qfilter.and("turns", "=", (Object)this.getModel().getDataEntity().getString("turns"));
        qfilter.and("supplier", ">", (Object)0L);
        String selectFields = "id,purlist.id,vieratio,viediffer,viefrom,vieto";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)selectFields, (QFilter[])qfilter.toArray());
        if (rows.size() == 0) {
            return Collections.emptyMap();
        }
        Map<Long, DynamicObject> purlistMap = rows.stream().collect(Collectors.groupingBy(e -> e.getLong("purlist.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        return purlistMap;
    }

    private String getViePattern() {
        DynamicObject projectObj = this.getModel().getDataEntity().getDynamicObject("project");
        String viePattern = projectObj.getString("viepattern");
        if (StringUtils.isBlank((CharSequence)viePattern)) {
            viePattern = "1";
        }
        return viePattern;
    }

    private String getVieType() {
        DynamicObject projectObj = this.getModel().getDataEntity().getDynamicObject("project");
        String vieType = projectObj.getString("vietype");
        return vieType;
    }

    private String getTaxType() {
        DynamicObject projectObj = this.getModel().getDataEntity().getDynamicObject("project");
        String taxType = projectObj.getString("taxtype");
        return taxType;
    }

    private QFilter getQFilter() {
        QFilter qfilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity().getDynamicObject("project")));
        qfilter.and("turns", "=", (Object)this.getModel().getDataEntity().getString("turns"));
        qfilter.and("supplier", ">", (Object)0L);
        return qfilter;
    }
}

