/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.vie;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.src.common.vie.SrcVieFacade;
import org.apache.commons.lang3.StringUtils;

public class SrcVieExceptionPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(SrcVieExceptionPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "confirm": {
                this.confirm(evt);
                break;
            }
        }
    }

    private void confirm(BeforeDoOperationEventArgs evt) {
        if (this.verifyData(evt)) {
            PdsVieContext context = this.createVieContext();
            SrcVieFacade.vieHandle((PdsVieContext)context);
            if (!StringUtils.isBlank((CharSequence)context.getMessage())) {
                context.getView().showMessage(context.getMessage());
            }
        }
    }

    private boolean verifyData(BeforeDoOperationEventArgs evt) {
        String opinion;
        DynamicObject obj = this.getModel().getDataEntity();
        StringBuilder sb = new StringBuilder();
        String result = obj.getString("result");
        if (StringUtils.isBlank((CharSequence)result)) {
            sb.append(ResManager.loadKDString((String)"\u5904\u7406\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcVieExceptionPlugin_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)(opinion = obj.getString("opinion")))) {
            sb.append(ResManager.loadKDString((String)"\u5904\u7406\u610f\u89c1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcVieExceptionPlugin_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
        if ("F".equals(result) && obj.getInt("delaytime") == 0) {
            sb.append(ResManager.loadKDString((String)"\u5ef6\u957f\u65f6\u95f4(\u5206\u949f)\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"SrcVieExceptionPlugin_2", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            this.getView().showErrorNotification(sb.toString());
            evt.setCancel(true);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private PdsVieContext createVieContext() {
        PdsVieContext context = new PdsVieContext();
        context.setView(this.getView());
        Map paraMap = context.getView().getFormShowParameter().getCustomParams();
        context.setProjectId(PdsCommonUtils.object2Long(paraMap.get("billid")));
        DynamicObject viebillObj = PdsVieHelper.getVieBillObj((long)context.getProjectId());
        context.setVieBillObj(viebillObj);
        context.setBidStatus(viebillObj.getString("bidstatus"));
        context.setTurns(PdsCommonUtils.object2String(paraMap.get("turns"), (String)"1"));
        context.setVieturns(PdsCommonUtils.object2String(paraMap.get("vieturns"), (String)"1"));
        if (null != paraMap.get("bidtime")) {
            context.setBidtimes((Integer)paraMap.get("bidtime") * 60);
        }
        context.setHandleType(this.getModel().getDataEntity().getString("result"));
        context.setOpinion(this.getModel().getValue("opinion").toString());
        context.setDelayTimes((long)this.getModel().getDataEntity().getInt("delaytime"));
        return context;
    }
}

