/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.vie;

import java.util.EventObject;
import java.util.Iterator;
import java.util.Set;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.common.util.DateUtil;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.enums.VieTurnsEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.src.common.vie.SrcVieFactory;

public class SrcVieSupplierOnlinePlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        this.createEntry();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "refresh": {
                this.createEntry();
                break;
            }
            case "initial": {
                PdsVieContext context = SrcVieFactory.createVieContext((IFormView)this.getView().getParentView());
                String statusKey = PdsVieHelper.getSupplierVieOnlineKey((PdsVieContext)context);
                PdsVieHelper.getInstance().remove(statusKey);
                this.createEntry();
                break;
            }
        }
    }

    public void createEntry() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        Set supplierIds = PdsVieHelper.getAllVieSupplierIdSet((long)this.getProjectId(), (String)this.getTurns());
        if (null == supplierIds || supplierIds.size() == 0) {
            return;
        }
        PdsVieContext context = new PdsVieContext();
        context.setProjectId(this.getProjectId());
        context.setTurns(this.getTurns());
        context.setVieturns(this.getVieTurns());
        model.beginInit();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int index = 0;
        Iterator iterator = supplierIds.iterator();
        while (iterator.hasNext()) {
            long supplierId = (Long)iterator.next();
            ts.set("supplier", (Object)supplierId, index);
            context.setSupplierId(supplierId);
            String[] status = PdsVieHelper.getSupplierOnlineStatus((PdsVieContext)context);
            if ("0".equals(status[0])) {
                ts.set("isonline", (Object)false, index);
                ts.set("signintime", null, index);
                ts.set("count", null, index);
            } else {
                ts.set("isonline", (Object)true, index);
                ts.set("signintime", (Object)DateUtil.string2date((String)status[1], (String)"yyyy-MM-dd HH:mm:ss"), index);
                ts.set("count", (Object)status[0], index);
            }
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private long getProjectId() {
        return PdsCommonUtils.object2Long((Object)PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"project"));
    }

    private String getTurns() {
        return PdsCommonUtils.object2String((Object)PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"turns"), (String)QuoteTurnsEnums.NEGOTIATE00.getValue());
    }

    private String getVieTurns() {
        return PdsCommonUtils.object2String((Object)PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"vieturns"), (String)VieTurnsEnums.VIE01.getValue());
    }
}

