/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.enums.ResultStatusEnums;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsObjectCacheUtils;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.calc.SrcGlobalCalcContext;
import kd.scm.src.common.calc.rank.SrcRankFacade;
import kd.scm.src.common.calc.ratio.SrcRatioFacade;
import kd.scm.src.common.calc.total.SrcTotalFacade;
import kd.scm.src.common.util.SrcProjectUtil;

public class SrcDecisionCalculateOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("id");
        fields.add("sourceclass");
        fields.add("openstatus");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs evt) {
        super.beforeExecuteOperationTransaction(evt);
        List dataEntity = evt.getValidExtDataEntities();
        String opKey = evt.getOperationKey();
        boolean isRankCalculate = false;
        for (ExtendedDataEntity extDataEntity : dataEntity) {
            DynamicObject billObj = extDataEntity.getDataEntity();
            String openStatus = billObj.getString("openstatus");
            if (StringUtils.isEmpty((CharSequence)openStatus) || BidOpenStatusEnums.NOOPEN.getValue().equals(openStatus) && SrcProjectUtil.isQuickPur((DynamicObject)billObj)) {
                SrcBidOpenFacade.setProjectOpenStatus((long)billObj.getLong("id"));
                openStatus = PdsObjectCacheUtils.getProjectOpenStatus((long)billObj.getLong("id"));
            }
            if (!BidOpenStatusEnums.TECOPEN.getValue().equals(openStatus) && !BidOpenStatusEnums.BIZOPEN.getValue().equals(openStatus) && !BidOpenStatusEnums.OPEN.getValue().equals(openStatus)) continue;
            switch (opKey) {
                case "recalculate": {
                    isRankCalculate = true;
                    break;
                }
                case "calculate": {
                    isRankCalculate = this.isAllowRankCalculate(billObj);
                    break;
                }
                case "ratiocalculate": {
                    isRankCalculate = false;
                    break;
                }
            }
            String entityId = billObj.getDataEntityType().getName();
            long projectId = PdsCommonUtils.object2Long((Object)billObj.getPkValue());
            SrcGlobalCalcContext gcontext = new SrcGlobalCalcContext();
            if (isRankCalculate) {
                SrcRankFacade.getInstance().calculate(entityId, projectId, gcontext, Boolean.TRUE.booleanValue());
                if (gcontext.getIsAllowSynthCalc() == 0) {
                    evt.setCancel(true);
                    evt.setCancelMessage(PdsCommonUtils.object2String(gcontext.getCustomMap().get("message"), (String)""));
                    return;
                }
            }
            SrcRatioFacade.getInstance().calculate(entityId, projectId, gcontext, Boolean.FALSE.booleanValue());
            SrcTotalFacade.getInstance().calculate(entityId, projectId, gcontext, Boolean.FALSE.booleanValue());
            if (gcontext.isSucced()) continue;
            evt.setCancel(true);
            evt.setCancelMessage(gcontext.getMessage().toString());
            return;
        }
    }

    private boolean isAllowRankCalculate(DynamicObject billObj) {
        if (this.isSellOffAndOffline(billObj)) {
            return false;
        }
        QFilter purlistFilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj));
        purlistFilter.and("entrystatus", "=", (Object)ProjectStatusEnums.OPENED.getValue());
        purlistFilter.and("result", "is not null", (Object)"");
        purlistFilter.and("result", "!=", (Object)" ");
        purlistFilter.and("result", "!=", (Object)ResultStatusEnums.LOSE.getValue());
        if (!QueryServiceHelper.exists((String)"src_purlistf7", (QFilter[])purlistFilter.toArray())) {
            return true;
        }
        QFilter bidassessFilter = new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj));
        if (!QueryServiceHelper.exists((String)"src_bidassess_biz", (QFilter[])bidassessFilter.toArray())) {
            return true;
        }
        QFilter rankFilter = new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj));
        rankFilter.and("rank", "=", (Object)0);
        rankFilter.and("result", "!=", (Object)ResultStatusEnums.NOTRECOMMEND.getValue());
        rankFilter.and("result", "!=", (Object)ResultStatusEnums.NOPASSAPTITUDE.getValue());
        rankFilter.and("result", "is not null", (Object)"");
        rankFilter.and("result", "!=", (Object)" ");
        return QueryServiceHelper.exists((String)"src_bidassess_biz", (QFilter[])rankFilter.toArray());
    }

    private boolean isSellOffAndOffline(DynamicObject billObj) {
        return billObj.getString("sourcetype.number").equals(SourceTypeEnums.SELL_OFF.getValue()) && billObj.getString("sourceclass.number").equals("C011402");
    }
}

