/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.srcbotp.SrcBotpUtils;
import kd.scm.src.common.util.SrcDemandUtils;

public class SrcDemandSetDefaultOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("ismultiscene");
        filds.add("sceneitem");
        filds.add("sourcetype2");
        filds.add("srctype2");
        filds.add("taxtype");
        filds.add("sumtaxamount");
        filds.add("sumamount");
        filds.add("supplierscope");
        filds.add("entrysupplier.supplier");
        filds.add("entry.scenetaxamount");
        filds.add("entry.sceneamount");
        filds.add("entry.scenename_des1");
        filds.add("entry.purtype");
        filds.add("entry.srcflowconfig");
        filds.add("entry.scenestatus");
        filds.add("entry.decisionitem");
        filds.add("entry.category");
        filds.add("entry.purlisttpl");
        filds.add("entryentity.taxamount");
        filds.add("entryentity.amount");
        filds.add("entryentity.material1");
        filds.add("entryentity.category2");
        filds.add("entryentity.unit2");
        filds.add("entryentity.currency");
        filds.add("entryentity.price12");
        filds.add("entryentity.price13");
        filds.add("entryentity.price14");
        filds.add("entryentity.price15");
        filds.add("entryentity.price2");
        filds.add("entryentity.price3");
        filds.add("entryentity.reqsource11");
        filds.add("entryentity.srcbillno");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        boolean hasSetDefault = this.getOption().containsVariable("srcdemand_hassetdefaultval");
        if (!hasSetDefault) {
            for (DynamicObject obj : dataEntities) {
                this.updateReferPrice(obj);
                this.setEntryOrg(obj);
                this.setSrcBillNoValue(obj);
                this.setSumAmount(obj);
                this.setSceneDefaultValue(obj);
            }
        }
    }

    public void updateReferPrice(DynamicObject obj) {
        SrcDemandUtils.updateReferPrice((DynamicObject)obj);
    }

    private void setSrcBillNoValue(DynamicObject obj) {
        DynamicObjectCollection rows = obj.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < rows.size(); ++i) {
            if (!Objects.equals(((DynamicObject)rows.get(i)).getString("reqsource11"), "3")) continue;
            ((DynamicObject)rows.get(i)).set("srcbillno", obj.get("billno"));
        }
    }

    private void setEntryOrg(DynamicObject obj) {
        DynamicObjectCollection rows = obj.getDynamicObjectCollection("entryentity");
        for (int index = 0; index < rows.size(); ++index) {
            DynamicObject entryOrgObj = ((DynamicObject)rows.get(index)).getDynamicObject("entryorg");
            if (Objects.isNull(entryOrgObj)) {
                ((DynamicObject)rows.get(index)).set("entryorg", (Object)obj.getLong("org.id"));
                continue;
            }
            String reqSource = ((DynamicObject)rows.get(index)).getString("reqsource11");
            if (Objects.equals(reqSource, "2")) continue;
            ((DynamicObject)rows.get(index)).set("entryorg", (Object)obj.getLong("org.id"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSumAmount(DynamicObject obj) {
        BigDecimal amount;
        String taxType = obj.getString("taxtype");
        DynamicObjectCollection cols = obj.getDynamicObjectCollection("entry");
        String amountPro = "";
        if (cols.size() == 0) {
            cols = obj.getDynamicObjectCollection("entryentity");
            if (Objects.equals(taxType, "1") || Objects.equals(taxType, "3")) {
                amountPro = "taxamount";
            } else {
                if (!Objects.equals(taxType, "2")) return;
                amountPro = "amount";
            }
        } else if (Objects.equals(taxType, "1") || Objects.equals(taxType, "3")) {
            amountPro = "scenetaxamount";
        } else {
            if (!Objects.equals(taxType, "2")) return;
            amountPro = "sceneamount";
        }
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject col : cols) {
            totalAmount = totalAmount.add(col.getBigDecimal(amountPro));
        }
        if (Objects.equals(taxType, "1") || Objects.equals(taxType, "3")) {
            amount = obj.getBigDecimal("sumtaxamount");
            if (amount.compareTo(totalAmount) >= 0) return;
            obj.set("sumtaxamount", (Object)totalAmount);
            return;
        } else {
            if (!Objects.equals(taxType, "2") || (amount = obj.getBigDecimal("sumamount")).compareTo(totalAmount) >= 0) return;
            obj.set("sumamount", (Object)totalAmount);
        }
    }

    public void setSceneDefaultValue(DynamicObject obj) {
        if (obj.getBoolean("ismultiscene")) {
            return;
        }
        DynamicObject sourceType = obj.getDynamicObject("srctype2.sourcetype");
        if (null != sourceType) {
            obj.set("sourcetype2", (Object)sourceType);
        }
        DynamicObjectCollection rows = obj.getDynamicObjectCollection("entry");
        rows.removeAll((Collection)rows);
        DynamicObject row = rows.addNew();
        row.set("scenename_des1", obj.get("title"));
        row.set("purtype", obj.get("sourcetype2"));
        row.set("srcflowconfig", (Object)obj.getDynamicObject("srctype2"));
        this.setSceneSuppliers(obj, row);
        row.set("scenestatus", (Object)"A");
        row.set("scenetaxamount", obj.get("sumtaxamount"));
        row.set("sceneamount", obj.get("sumamount"));
        MultiBasedataUtils.setMultiBasedataForEntryRow((DynamicObject)row, this.getPurlistId(obj), (String)"decisionitem");
        MultiBasedataUtils.setMultiBasedataForEntryRow((DynamicObject)row, this.getCategoryId(obj), (String)"category");
    }

    private void setSceneSuppliers(DynamicObject obj, DynamicObject row) {
        Set supplierIds = null;
        DynamicObjectCollection rows = obj.getDynamicObjectCollection("entrysupplier");
        if (rows.size() > 0) {
            supplierIds = rows.stream().filter(e -> e.getLong("supplier.id") > 0L).map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
        }
        if (null == supplierIds || supplierIds.size() == 0) {
            supplierIds = MultiBasedataUtils.getBasedataIdSet((DynamicObject)obj, (String)"supplierscope");
        }
        if (null != supplierIds && supplierIds.size() > 0) {
            MultiBasedataUtils.setMultiBasedataForEntryRow((DynamicObject)row, supplierIds, (String)"suppliers");
        }
    }

    private Set<Long> getPurlistId(DynamicObject obj) {
        DynamicObjectCollection rows = obj.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : rows) {
            Long entryId = row.getLong("id");
            if (entryId != 0L) continue;
            PdsCommonUtils.setPrimaryKey((DynamicObject)row);
        }
        return rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
    }

    private Set<Long> getCategoryId(DynamicObject obj) {
        DynamicObjectCollection rows = obj.getDynamicObjectCollection("entryentity");
        return rows.stream().map(e -> e.getLong("category2.id")).collect(Collectors.toSet());
    }

    public void setScenePurlistTpl(DynamicObject obj) {
        if (!obj.getBoolean("sceneitem")) {
            return;
        }
        DynamicObjectCollection rows = obj.getDynamicObjectCollection("entry");
        for (DynamicObject row : rows) {
            long defaultTplId = SrcBotpUtils.getDefaultPurlistTplId((DynamicObject)row.getDynamicObject("purtype"));
            row.set("purlisttpl", (Object)new Object[]{defaultTplId});
        }
    }
}

