/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PayStatusEnums;
import kd.scm.pds.common.feemanage.FeeManageUtils;
import kd.scm.src.common.util.SrcBidCompTplUtil;

public class SrcPayManageUnAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        HashSet<String> payStatusSet = new HashSet<String>(4);
        payStatusSet.add(PayStatusEnums.NOCONFIRM.getValue());
        payStatusSet.add(PayStatusEnums.CONFIRMED.getValue());
        payStatusSet.add(PayStatusEnums.RETURNED.getValue());
        payStatusSet.add(PayStatusEnums.TRANSFERED.getValue());
        payStatusSet.add(PayStatusEnums.CARRYOVER.getValue());
        List validExtDataEntities = args.getValidExtDataEntities();
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            DynamicObject projectObj = extendedDataEntity.getDataEntity();
            if (!FeeManageUtils.isNeedHandlePaypment((DynamicObject)projectObj)) continue;
            if (SrcBidCompTplUtil.isProjectEnded((DynamicObject)projectObj)) {
                args.setCancel(true);
                args.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u5bfb\u6e90\u9879\u76ee\u5df2\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"SrcPayManageUnAuditOp_2", (String)"scm-src-opplugin", (Object[])new Object[0]));
                continue;
            }
            long projectId = projectObj.getLong("id");
            QFilter qfilters = new QFilter("project", "=", (Object)projectId).and(new QFilter("entrystatus", "in", payStatusSet));
            if (!QueryServiceHelper.exists((String)"src_payment", (QFilter[])qfilters.toArray())) continue;
            args.setCancel(true);
            args.setCancelMessage(ResManager.loadKDString((String)"\u6536\u8d39\u660e\u7ec6\uff1a\u5df2\u63d0\u4ea4/\u5df2\u786e\u8ba4/\u5df2\u9000\u8fd8/\u5df2\u7ed3\u4f59\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SrcPayManageUnAuditOp_1", (String)"scm-src-opplugin", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] projectObjs;
        for (DynamicObject projectObj : projectObjs = args.getDataEntities()) {
            if (!FeeManageUtils.isNeedHandlePaypment((DynamicObject)projectObj)) continue;
            try (TXHandle tx = TX.requiresNew();){
                FeeManageUtils.deletePaymentEntry((long)SrmCommonUtil.getPkValue((DynamicObject)projectObj));
            }
        }
    }
}

