/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.util.PdsFlowConfigUtils;
import kd.scm.src.common.enums.SrcBizStatusEnum;
import kd.scm.src.common.util.SrcBidCompTplUtil;

public class SrcProjectAuditOp
extends AbstractOperationServicePlugIn {
    private Map<String, String> haveCreatedMap = new HashMap<String, String>(8);
    private boolean parentHasChildren = false;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("bizstatus");
        fields.add("source");
        fields.add("srctype");
        fields.add("ispackage");
        fields.add("creator");
        fields.add("createtime");
        fields.add("projectcreator");
        fields.add("projectcreatetime");
        fields.add("currentnode");
        fields.add("entrymainflow.biznode");
        fields.add("entrymainflow.bizobject");
        fields.add("entrymainflow.comptemplate");
        fields.add("entrymainflow.extobject");
        fields.add("entrymainflow.isflowchart");
        fields.add("entrymainflow.flowbillstatus");
        fields.add("entrymainflow.flowbizstatus");
        fields.add("entrysubflow.subbiznode");
        fields.add("entrysubflow.subextobject");
        fields.add("entrysubflow.subcomptemplate");
        fields.add("entrysubflow.subisflowchart");
        fields.add("entrysubflow.subisaudit");
        fields.add("entrysubflow.subflowbillstatus");
        fields.add("entrysubflow.subflowbizstatus");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] objs;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject obj : objs = e.getDataEntities()) {
            if ("src_project".equals(obj.getDataEntityType().getName()) && PdsFlowConfigUtils.existsSpecificNode((DynamicObject)obj, (String)PdsBizNodeEnums.PREPROJECT.getValue())) continue;
            obj.set("bizstatus", (Object)SrcBizStatusEnum.HANDLED.getVal());
            obj.set("projectcreator", obj.get("creator"));
            obj.set("projectcreatetime", obj.get("createtime"));
            DynamicObjectCollection entryNodeCols = obj.getDynamicObjectCollection("entrymainflow");
            this.haveCreatedMap.clear();
            int isNeedAuditSize = 0;
            int entryNodeSize = entryNodeCols.size();
            for (int i = 0; i < entryNodeSize; ++i) {
                int subEntrySize;
                DynamicObject entryNodeCol = (DynamicObject)entryNodeCols.get(i);
                DynamicObjectCollection subEntryCols = entryNodeCol.getDynamicObjectCollection("entrysubflow");
                isNeedAuditSize = subEntrySize = subEntryCols.size();
                for (int j = 0; j < subEntrySize; ++j) {
                    DynamicObject subEntryCol = (DynamicObject)subEntryCols.get(j);
                    boolean isAudit = subEntryCol.getBoolean("subisaudit");
                    String bizStatus = subEntryCol.getString("subflowbizstatus");
                    if (!isAudit || SrcBizStatusEnum.HANDLED.getVal().equals(bizStatus)) {
                        --isNeedAuditSize;
                    }
                    this.createOrUpdateExtObjEntry(obj, subEntryCol, i);
                }
                if (i != 0) {
                    this.createOrUpdateExtObjEntry(obj, entryNodeCol, i);
                    continue;
                }
                if (isNeedAuditSize <= 0) continue;
                this.parentHasChildren = true;
            }
        }
        this.updateBizEntryStatus(objs);
    }

    private DynamicObject createOrUpdateExtObjEntry(DynamicObject obj, DynamicObject node, int rowIndex) {
        String extObj;
        String prefix = "";
        boolean isSubEntry = false;
        if (node.getDataEntityType() instanceof SubEntryType) {
            isSubEntry = true;
            prefix = "sub";
        }
        if (null == (extObj = node.getString(prefix + "extobject")) || extObj.trim().length() == 0) {
            return null;
        }
        if (null != this.haveCreatedMap.get(extObj)) {
            return null;
        }
        Map<String, String> scpecialHandleExtObjMap = this.getSpecialHandleExtObjs();
        if (null != scpecialHandleExtObjMap.get(extObj)) {
            SrcBidCompTplUtil.handleSpecialExtObjs((DynamicObject)obj, (DynamicObject)node);
            return null;
        }
        this.haveCreatedMap.putIfAbsent(extObj, extObj);
        DynamicObject extObjDy = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)extObj);
        DynamicObjectCollection entryCols = extObjDy.getDynamicObjectCollection("entryentity");
        DynamicObject entry = null;
        if (entryCols.size() == 0) {
            entry = entryCols.addNew();
        }
        if ((Long)(entry = (DynamicObject)entryCols.get(0)).getPkValue() == 0L) {
            entry.set("id", obj.getPkValue());
        }
        if (isSubEntry) {
            this.setNodeStatus(entry, false, 1);
        } else {
            this.setNodeStatus(entry, false, rowIndex);
        }
        DynamicObject template = node.getDynamicObject(prefix + "comptemplate");
        if (null != template) {
            entry.set("template", template.getPkValue());
            entry.set("creator", (Object)RequestContext.get().getCurrUserId());
            entry.set("createtime", (Object)TimeServiceHelper.now());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extObjDy});
        return extObjDy;
    }

    protected Map<String, String> getSpecialHandleExtObjs() {
        Map scpecialHandleExtObjMap = SrcBidCompTplUtil.getSpecialHandleExtObjs();
        return scpecialHandleExtObjMap;
    }

    private void updateBizEntryStatus(DynamicObject[] objs) {
        for (DynamicObject obj : objs) {
            this.parentHasChildren = false;
            DynamicObjectCollection entryNodeCols = obj.getDynamicObjectCollection("entrymainflow");
            int entryNodeSize = entryNodeCols.size();
            int isNeedAuditSize = 0;
            for (int i = 0; i < entryNodeSize; ++i) {
                DynamicObject subEntryCol;
                int j;
                DynamicObject entryNodeCol = (DynamicObject)entryNodeCols.get(i);
                DynamicObjectCollection subEntryCols = entryNodeCol.getDynamicObjectCollection("entrysubflow");
                int subEntrySize = subEntryCols.size();
                for (j = 0; j < subEntrySize; ++j) {
                    subEntryCol = (DynamicObject)subEntryCols.get(j);
                    boolean isAudit = subEntryCol.getBoolean("subisaudit");
                    String bizStatus = subEntryCol.getString("subflowbizstatus");
                    if (!isAudit || SrcBizStatusEnum.HANDLED.getVal().equals(bizStatus)) continue;
                    ++isNeedAuditSize;
                }
                if (isNeedAuditSize > 0 && i == 0) {
                    this.parentHasChildren = true;
                }
                for (j = 0; j < subEntrySize; ++j) {
                    subEntryCol = (DynamicObject)subEntryCols.get(j);
                    this.setNodeStatus(subEntryCol, true, i);
                }
                this.setNodeStatus(entryNodeCol, true, i);
                if (i == 1) break;
            }
            SrcBidCompTplUtil.updateCurrentNode((DynamicObject)obj);
        }
        SaveServiceHelper.save((DynamicObject[])objs);
    }

    private void setNodeStatus(DynamicObject entryNodeCol, boolean isFlowEntry, int rowIndex) {
        String prefix = "";
        boolean isSubEntry = false;
        if (entryNodeCol.getDataEntityType() instanceof SubEntryType) {
            isSubEntry = true;
            prefix = "sub";
        }
        String bizStatusKey = null;
        String billStatusKey = null;
        if (isFlowEntry) {
            bizStatusKey = prefix + "flowbizstatus";
            billStatusKey = prefix + "flowbillstatus";
        } else {
            bizStatusKey = "bizstatus";
            billStatusKey = "billstatus";
        }
        String bizStatusVal = entryNodeCol.getString(bizStatusKey);
        String billStatusVal = entryNodeCol.getString(billStatusKey);
        if (SrcBizStatusEnum.HANDLED.getVal().equals(bizStatusVal) || BillStatusEnum.AUDIT.getVal().equals(billStatusVal)) {
            return;
        }
        if (rowIndex == 0) {
            if (isSubEntry) {
                entryNodeCol.set(bizStatusKey, (Object)SrcBizStatusEnum.PROCESSING.getVal());
                entryNodeCol.set(billStatusKey, (Object)BillStatusEnum.SAVE.getVal());
            } else {
                entryNodeCol.set(bizStatusKey, (Object)SrcBizStatusEnum.HANDLED.getVal());
                entryNodeCol.set(billStatusKey, (Object)BillStatusEnum.AUDIT.getVal());
            }
        } else if (rowIndex == 1 && !this.parentHasChildren) {
            entryNodeCol.set(bizStatusKey, (Object)SrcBizStatusEnum.PROCESSING.getVal());
            entryNodeCol.set(billStatusKey, (Object)BillStatusEnum.SAVE.getVal());
        } else {
            entryNodeCol.set(bizStatusKey, (Object)SrcBizStatusEnum.NOTSTART.getVal());
            entryNodeCol.set(billStatusKey, (Object)BillStatusEnum.SAVE.getVal());
        }
    }
}

