/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.BizLog;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.util.PdsBOTPUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsFlowConfigUtils;

public class SrcProjectAutoNoticeAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        super.onPreparePropertys(evt);
        evt.getFieldKeys().add("isbidnotice");
        evt.getFieldKeys().add("iswinnotice");
        evt.getFieldKeys().add("isendnotice");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
        DynamicObject[] billObjs = evt.getDataEntities();
        String billType = billObjs[0].getDynamicObjectType().getName();
        for (DynamicObject billObj : billObjs) {
            if (!this.isExistNoticeNode(billObj, billType)) continue;
            Map resultMap = PdsBOTPUtils.pushBill((String)billType, (String)"sou_notice", (DynamicObject)billObj, null);
            if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                BizLog.log((String)String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u516c\u544a\u5931\u8d25: %1$s\u3002", (String)"SrcProjectAutoNoticeAuditOp_0", (String)"scm-src-opplugin", (Object[])new Object[0]), resultMap.get("message")));
                continue;
            }
            this.updatePustNoticeStatus(billObj, billType);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])billObjs);
    }

    private boolean isExistNoticeNode(DynamicObject billObj, String billType) {
        switch (billType) {
            case "src_project": {
                if (!PdsFlowConfigUtils.existsSpecificNode((DynamicObject)billObj, (String)PdsBizNodeEnums.PUBLISHNOTICE.getValue())) break;
                return true;
            }
            case "src_decision": {
                if (!PdsFlowConfigUtils.existsSpecificNode((DynamicObject)billObj, (String)PdsBizNodeEnums.PUBLISHWINNOTICE.getValue())) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private void updatePustNoticeStatus(DynamicObject billObj, String billType) {
        switch (billType) {
            case "src_project": {
                billObj.set("isbidnotice", (Object)true);
                break;
            }
            case "src_decision": {
                billObj.set("iswinnotice", (Object)true);
                break;
            }
        }
    }
}

