/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcDemandUtils;

public class SrcProjectDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("scene");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] billObjs = e.getDataEntities();
        Object[] sceneIds = Arrays.stream(billObjs).map(obj -> Optional.ofNullable(obj.getDynamicObject("scene")).map(DataEntityBase::getPkValue).orElse(null)).filter(Objects::nonNull).toArray();
        if (sceneIds.length > 0) {
            SrcDemandUtils.updateSceneStatus((Object[])sceneIds, (String)"A");
        }
        ArrayList<Long> parentIdList = new ArrayList<Long>(billObjs.length);
        for (DynamicObject data : billObjs) {
            parentIdList.add(PdsCommonUtils.object2Long((Object)data.getPkValue()));
        }
        if (parentIdList.size() == 0) {
            return;
        }
        QFilter filter = new QFilter("billid", "in", parentIdList);
        DeleteServiceHelper.delete((String)"src_supplierinvite", (QFilter[])new QFilter[]{filter});
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] billObjs = e.getDataEntities();
        DynamicObjectCollection tpls = this.getPurlistData(billObjs);
        this.setOperateVariables(e, tpls);
        HashSet<Long> tplIdSet = new HashSet<Long>();
        for (DynamicObject tpl : tpls) {
            tplIdSet.add(tpl.getLong("id"));
        }
        if (!tplIdSet.isEmpty()) {
            OperationServiceHelper.executeOperate((String)"delete", (String)"src_purlistcomptpl", (Object[])tplIdSet.toArray(), null);
        }
    }

    private void setOperateVariables(BeforeOperationArgs e, DynamicObjectCollection tpls) {
        DynamicObject[] dataEntity = e.getDataEntities();
        HashMap reqidmap = new HashMap();
        HashMap<Long, String> orgmap = new HashMap<Long, String>();
        for (DynamicObject dynamicObject : dataEntity) {
            orgmap.put(dynamicObject.getLong("id"), dynamicObject.getString("org.id"));
        }
        List<String> srcEntryIdlist = new ArrayList();
        for (DynamicObject entry : tpls) {
            Long billId = Long.valueOf(entry.getString("parentid"));
            srcEntryIdlist = (List)reqidmap.get(billId);
            if (null == srcEntryIdlist) {
                srcEntryIdlist = new ArrayList(8);
            }
            srcEntryIdlist.add(entry.getString("srcentryid"));
            reqidmap.put(billId, srcEntryIdlist);
        }
        this.operateOption.setVariableValue("reqids", SerializationUtils.toJsonString(reqidmap));
        this.operateOption.setVariableValue("reqorgs", SerializationUtils.toJsonString(orgmap));
    }

    private DynamicObjectCollection getPurlistData(DynamicObject[] billObjs) {
        Object[] ids = Arrays.stream(billObjs).map(obj -> obj.getString("id")).toArray();
        QFilter idfilter = new QFilter("parentid", "in", (Object)ids);
        DynamicObjectCollection tpls = QueryServiceHelper.query((String)"src_purlistcomptpl", (String)"id,parentid,entryentity.id,entryentity.srcentryid srcentryid", (QFilter[])idfilter.toArray());
        return tpls;
    }
}

