/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcProjectInitPriceUnAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("sourcetype");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
        DynamicObject[] billObjs;
        for (DynamicObject billObj : billObjs = evt.getDataEntities()) {
            DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)SrmCommonUtil.getPkValue((DynamicObject)billObj), (String)"src_project");
            String sourceType = projectObj.getString("sourcetype.number");
            if (!SourceTypeEnums.INPUT_PRICE.getValue().equals(sourceType) && !SourceTypeEnums.DIRECT_PUR.getValue().equals(sourceType) && !SourceTypeEnums.INTERNAL_SALE.getValue().equals(sourceType) && !SourceTypeEnums.NET_PUR.getValue().equals(sourceType)) continue;
            this.updatePurlistStatus(projectObj);
            this.unAuditDecision(projectObj, evt.getOperationKey(), sourceType);
            QFilter qfilter = new QFilter("parentid", "=", (Object)String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)projectObj)));
            DeleteServiceHelper.delete((String)"src_decisionsum_sup", (QFilter[])qfilter.toArray());
        }
    }

    public void unAuditDecision(DynamicObject projectObj, String operationKey, String sourceType) {
        ExtPluginContext context = new ExtPluginContext();
        context.setOperationKey(operationKey);
        context.setBillObj(projectObj);
        context.setBillId(SrmCommonUtil.getPkValue((DynamicObject)projectObj));
        context.setProjectObj(projectObj);
        context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)projectObj));
        ExtPluginFactory.executeExtplugin((String)PdsCommonUtils.buildString((Object[])new Object[]{"src_project_audit", "_", sourceType}), (ExtPluginContext)context, (boolean)false);
    }

    private void updatePurlistStatus(DynamicObject projectObj) {
        String selectFields = "entrystatus, result, billtype";
        QFilter qFilters = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)projectObj));
        DynamicObject[] purlistObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])qFilters.toArray());
        if (null == purlistObjs || purlistObjs.length == 0) {
            return;
        }
        for (DynamicObject purlistObj : purlistObjs) {
            purlistObj.set("entrystatus", (Object)ProjectStatusEnums.TOQUOTE.getValue());
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])purlistObjs);
    }
}

