/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcProjectNoticeUnAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        super.onPreparePropertys(evt);
        evt.getFieldKeys().add("isbidnotice");
        evt.getFieldKeys().add("iswinnotice");
        evt.getFieldKeys().add("isendnotice");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
        DynamicObject[] billObjs = evt.getDataEntities();
        String billType = billObjs[0].getDynamicObjectType().getName();
        for (DynamicObject billObj : billObjs) {
            switch (billType) {
                case "src_project": {
                    this.deleteNotice(billObj, billType);
                    billObj.set("isbidnotice", (Object)false);
                    break;
                }
                case "src_decision": {
                    this.deleteNotice(billObj, billType);
                    billObj.set("iswinnotice", (Object)false);
                    break;
                }
            }
            billObj.set("isendnotice", (Object)false);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])billObjs);
    }

    private void deleteNotice(DynamicObject billObj, String billType) {
        QFilter qfilter = new QFilter("parentid", "=", (Object)billObj.getPkValue().toString());
        if (Objects.equals("src_project", billType)) {
            qfilter.and("entitykey", "=", (Object)"src_sourcenotice");
        } else if (Objects.equals("src_decision", billType)) {
            qfilter.and("entitykey", "=", (Object)"src_decisionnotice");
        }
        QFilter botpQfilter = new QFilter("sbillid", "=", billObj.getPkValue());
        if (Objects.equals("src_project", billType)) {
            DynamicObject sourceNotice = QueryServiceHelper.queryOne((String)"src_sourcenotice", (String)"id", (QFilter[])qfilter.toArray());
            if (Objects.isNull(sourceNotice)) {
                return;
            }
            botpQfilter.and("tbillid", "=", (Object)sourceNotice.getLong("id"));
        } else if (Objects.equals("src_decision", billType)) {
            DynamicObject decisionNotice = QueryServiceHelper.queryOne((String)"src_decisionnotice", (String)"id", (QFilter[])qfilter.toArray());
            if (Objects.isNull(decisionNotice)) {
                return;
            }
            botpQfilter.and("tbillid", "=", (Object)decisionNotice.getLong("id"));
        }
        DeleteServiceHelper.delete((String)"botp_billtracker", (QFilter[])botpQfilter.toArray());
        DeleteServiceHelper.delete((String)"src_sourcenotice", (QFilter[])qfilter.toArray());
    }
}

