/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class SrcSourceNoticeOperationService
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey;
        super.afterExecuteOperationTransaction(e);
        switch (operationKey = e.getOperationKey()) {
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                DynamicObject[] billObjs;
                for (DynamicObject billObj : billObjs = e.getDataEntities()) {
                    this.doComponentOperation(operationKey, SrmCommonUtil.getPkValue((DynamicObject)billObj), billObj.getDataEntityType().getName());
                    this.attachmentHandle(operationKey, billObj);
                }
                break;
            }
        }
    }

    private void doComponentOperation(String operationKey, long projectId, String entityId) {
        QFilter qfilter = new QFilter("parentid", "=", (Object)String.valueOf(projectId));
        qfilter.and("pentitykey", "=", (Object)entityId);
        String selectFields = "billstatus,auditor,auditdate,billdate";
        String compKey = this.getCompKey(entityId);
        DynamicObject[] noticeObjs = BusinessDataServiceHelper.load((String)compKey, (String)selectFields, (QFilter[])qfilter.toArray());
        if (null == noticeObjs || noticeObjs.length == 0) {
            return;
        }
        block12: for (DynamicObject noticeObj : noticeObjs) {
            switch (operationKey) {
                case "submit": {
                    noticeObj.set("billstatus", (Object)BillStatusEnum.SUBMIT.getVal());
                    continue block12;
                }
                case "unsubmit": {
                    noticeObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
                    continue block12;
                }
                case "audit": {
                    noticeObj.set("billstatus", (Object)BillStatusEnum.AUDIT.getVal());
                    noticeObj.set("auditor", (Object)RequestContext.get().getCurrUserId());
                    noticeObj.set("auditdate", (Object)TimeServiceHelper.now());
                    noticeObj.set("billdate", (Object)TimeServiceHelper.now());
                    continue block12;
                }
                case "unaudit": {
                    noticeObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
                    noticeObj.set("auditor", null);
                    noticeObj.set("auditdate", null);
                    noticeObj.set("billdate", null);
                    continue block12;
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])noticeObjs);
    }

    private void attachmentHandle(String operationKey, DynamicObject billObj) {
        switch (operationKey) {
            case "audit": {
                this.cloneAttachments(billObj);
                break;
            }
            case "unaudit": {
                this.deleteAttachments(billObj);
                break;
            }
        }
    }

    private String getCompKey(String entityName) {
        String compKey = "src_sourcenotice";
        if ("src_publishnotice".equals(entityName)) {
            compKey = "src_sourcenotice";
        } else if ("src_publishwinnotice".equals(entityName)) {
            compKey = "src_decisionnotice";
        }
        return compKey;
    }

    private void cloneAttachments(DynamicObject billObj) {
        String compKey = this.getCompKey(billObj.getDataEntityType().getName());
        DynamicObject compObj = TemplateUtil.getCompData((DynamicObject)billObj, (String)compKey);
        HashSet<String> srcBillIds = new HashSet<String>();
        srcBillIds.add(billObj.getString("id"));
        AttachmentUtils.cloneAttachments((String)billObj.getDataEntityType().getName(), srcBillIds, (String)"sou_notice", (DynamicObject)compObj, null);
    }

    private void deleteAttachments(DynamicObject billObj) {
        String compKey = this.getCompKey(billObj.getDataEntityType().getName());
        DynamicObject compObj = TemplateUtil.getCompData((DynamicObject)billObj, (String)compKey);
        if (Objects.isNull(compObj)) {
            return;
        }
        HashSet<String> billIds = new HashSet<String>();
        billIds.add(compObj.getString("id"));
        QFilter attachFilters = new QFilter("finterid", "in", billIds);
        attachFilters.and("fattachmentpanel", "=", (Object)"attachmentpanel");
        attachFilters.and("fbilltype", "=", (Object)"sou_notice");
        DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])attachFilters.toArray());
    }
}

