/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.scm.pds.common.util.SrcDateUtils;

public class SrcStopBidDateUpgradePlugin
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(SrcStopBidDateUpgradePlugin.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u5bfb\u6e90\u534f\u540c-\u6295\u6807\u5355/\u62a5\u4ef7\u5355-\u6295\u6807\u622a\u6b62\u65f6\u95f4\u65e7\u6570\u636e\u5347\u7ea7\u3002", (String)"SrcStopBidDateUpgradePlugin_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
            this.upgrade(pProcessInfo, dbKey, "t_src_biddocbill");
            this.upgrade(pProcessInfo, dbKey, "t_src_quotebill");
            result.setLog(pProcessInfo.append(ResManager.loadKDString((String)"\u65e7\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5\u3002", (String)"SrcStopBidDateUpgradePlugin_1", (String)"scm-src-opplugin", (Object[])new Object[0])).toString());
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            String errorInfo = ResManager.loadKDString((String)"\u65e7\u6570\u636e\u5347\u7ea7\u6267\u884c\u5f02\u5e38\u3002", (String)"SrcStopBidDateUpgradePlugin_2", (String)"scm-src-opplugin", (Object[])new Object[0]);
            logger.error(errorInfo, (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    private void upgrade(StringBuilder pProcessInfo, String dbKey, String tableId) {
        int pageSize = 200;
        DBRoute dbRoute = new DBRoute(dbKey);
        String sqlAll = "select fid from " + tableId + " where fdeadline is null order by fid";
        try (DataSet dataSet = DB.queryDataSet((String)"SrcStopBidDateUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sqlAll, null);){
            ArrayList idList = new ArrayList();
            dataSet.forEach(row -> idList.add(row.getLong("fid")));
            pProcessInfo.append(ResManager.loadKDString((String)"\u83b7\u53d6\u603b\u6570\u636e\u91cf", (String)"SrcStopBidDateUpgradePlugin_4", (String)"scm-src-opplugin", (Object[])new Object[0])).append(idList.size()).append("\n");
            int count = idList.size();
            int totalPages = count / pageSize;
            if (count % pageSize != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List subIdList = (pageIndex + 1) * pageSize > idList.size() ? idList.subList(pageIndex * pageSize, idList.size()) : idList.subList(pageIndex * pageSize, (pageIndex + 1) * pageSize);
                if (subIdList.isEmpty()) continue;
                String ids = String.join((CharSequence)",", (CharSequence[])subIdList.stream().map(String::valueOf).toArray(String[]::new));
                String sql = "select fid,fdeadline from " + tableId + " where fid in (" + ids + ")  order by fid";
                Map<Long, Date> sqlParms = this.callProjectIdUpgradePlugin(dbRoute, sql);
                dbRoute = new DBRoute(dbKey);
                ArrayList<Object[]> parms = new ArrayList<Object[]>(sqlParms.size());
                for (Map.Entry<Long, Date> entry : sqlParms.entrySet()) {
                    Object[] parm = new Object[]{entry.getValue(), entry.getKey()};
                    parms.add(parm);
                }
                if (parms.isEmpty()) {
                    return;
                }
                this.updateData(dbRoute, parms, tableId);
            }
        }
    }

    private Map<Long, Date> callProjectIdUpgradePlugin(DBRoute dbRoute, String sql) {
        HashMap<Long, Date> sqlParms = new HashMap<Long, Date>();
        try (DataSet dataSet = DB.queryDataSet((String)"SrcStopBidDateUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sql, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    sqlParms.put(row.getLong("fid"), SrcDateUtils.getMaxDate());
                }
            }
        }
        return sqlParms;
    }

    private void updateData(DBRoute dbRoute, List<Object[]> parms, String tableId) {
        DB.executeBatch((DBRoute)dbRoute, (String)("update " + tableId + " set fdeadline = ? where fid = ?"), parms);
    }
}

