/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.addsupplier;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsPurlistUtils;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.util.SrcPurListUtil;
import kd.scm.src.opplugin.addsupplier.ISrcAddSupplierHandler;
import kd.scm.src.opplugin.addsupplier.SrcAddSupplierContext;
import kd.scm.src.opplugin.addsupplier.SrcAddSupplierFacade;

public class SrcAddSupplierHandler
implements ISrcAddSupplierHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcAddSupplierContext context) {
        this.addSupplier(context);
    }

    public void addSupplier(SrcAddSupplierContext context) {
        String entityname = context.getBillObj().getString("entityname");
        long billId = context.getBillObj().getLong("billid");
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj().getDynamicObject("project"));
        String turns = context.getBillObj().getString("turns");
        DynamicObjectCollection itemSupRows = context.getBillObj().getDynamicObjectCollection("entryentity");
        if (itemSupRows == null || itemSupRows.size() == 0) {
            return;
        }
        Map purlistCompMap = SrcPurListUtil.getPurlistAllEntryMap((long)projectId);
        BizLog.log((String)String.format(ResManager.loadKDString((String)"\u8865\u5145\u4f9b\u5e94\u5546-\u539f\u59cb\u6807\u7684size:%1$s\u3002", (String)"SrcAddSupplierHandler_2", (String)"scm-src-opplugin", (Object[])new Object[0]), purlistCompMap.size()));
        Map compMap = SrcPurListUtil.getPurlistCompDataMap((String)entityname, (long)billId);
        BizLog.log((String)String.format(ResManager.loadKDString((String)"\u8865\u5145\u4f9b\u5e94\u5546-\u8bae\u4ef7\u5355\u7ec4\u4ef6\u6807\u8bc6\u53ca\u5bf9\u5e94\u7ec4\u4ef6\u6570\u636esize:%1$s\u3002", (String)"SrcAddSupplierHandler_3", (String)"scm-src-opplugin", (Object[])new Object[0]), compMap.size()));
        QFilter tenderQFilter = new QFilter("billid", "=", (Object)projectId);
        DynamicObjectCollection tenderSupRows = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"package.id,supplier.id", (QFilter[])tenderQFilter.toArray());
        Set tenderSupSet = tenderSupRows.stream().map(e -> e.getString("package.id") + '|' + e.getString("supplier.id")).collect(Collectors.toSet());
        BizLog.log((String)String.format(ResManager.loadKDString((String)"\u8865\u5145\u4f9b\u5e94\u5546-\u5f53\u524d\u9879\u76ee\u5df2\u6709\u56de\u6807\u8be6\u60c5:%1$s\u3002", (String)"SrcAddSupplierHandler_4", (String)"scm-src-opplugin", (Object[])new Object[0]), tenderSupSet.toString()));
        QFilter purlistQFilter = new QFilter("project", "=", (Object)projectId).and("turns", "=", (Object)turns);
        DynamicObjectCollection purlistRows = QueryServiceHelper.query((String)"src_purlistf7", (String)"turns,purlist.id,supplier.id", (QFilter[])purlistQFilter.toArray());
        Set purlistSupSet = purlistRows.stream().map(e -> e.getString("turns") + '|' + e.getString("purlist.id") + '|' + e.getString("supplier.id")).collect(Collectors.toSet());
        BizLog.log((String)String.format(ResManager.loadKDString((String)"\u8865\u5145\u4f9b\u5e94\u5546-\u8bae\u4ef7\u5f53\u524d\u8f6e\u6b21\u91c7\u8d2d\u6e05\u5355F7\u6570\u636e:%1$s\u3002", (String)"SrcAddSupplierHandler_5", (String)"scm-src-opplugin", (Object[])new Object[0]), purlistSupSet.toString()));
        ArrayList<DynamicObject> tenderSupObjs = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> purlistCompObjs = new ArrayList<DynamicObject>(16);
        for (DynamicObject itemSupRow : itemSupRows) {
            DynamicObjectCollection rows = this.getPurlistRows(context, itemSupRow);
            if (null == rows || rows.size() == 0) continue;
            for (DynamicObject row : rows) {
                long purlistId = row.getLong("purlist.id");
                long packageId = row.getLong("purlist.package.id");
                Set supplierIdSet = MultiBasedataUtils.getBasedataIdSet((DynamicObject)itemSupRow, (String)"supplier");
                if (supplierIdSet.size() == 0) continue;
                for (Long supplierId : supplierIdSet) {
                    String pkgSupKey = String.valueOf(packageId) + '|' + supplierId;
                    if (tenderSupSet.add(pkgSupKey)) {
                        DynamicObject tenderSupObj = SrcAddSupplierFacade.createTenderSupplier(context, projectId, packageId, supplierId);
                        BizLog.log((String)String.format(ResManager.loadKDString((String)"\u8865\u5145\u4f9b\u5e94\u5546-\u521b\u5efa\u56de\u6807\u8be6\u60c5:%1$s|%2$s|%3$s\u3002", (String)"SrcAddSupplierHandler_6", (String)"scm-src-opplugin", (Object[])new Object[0]), projectId, packageId, supplierId));
                        if (tenderSupObj != null) {
                            tenderSupObjs.add(tenderSupObj);
                        }
                    }
                    String turnsPurlistSupKey = turns + '|' + purlistId + '|' + supplierId;
                    BizLog.log((String)String.format(ResManager.loadKDString((String)"\u8865\u5145\u4f9b\u5e94\u5546-turns|purlistId|supplierId:%1$s\u3002", (String)"SrcAddSupplierHandler_7", (String)"scm-src-opplugin", (Object[])new Object[0]), turnsPurlistSupKey));
                    if (!purlistSupSet.add(turnsPurlistSupKey)) continue;
                    BizLog.log((String)String.format(ResManager.loadKDString((String)"\u8865\u5145\u4f9b\u5e94\u5546-\u521b\u5efa\u5f53\u524d\u8f6e\u6b21\u91c7\u8d2d\u6e05\u5355:%1$s\u3002", (String)"SrcAddSupplierHandler_8", (String)"scm-src-opplugin", (Object[])new Object[0]), turnsPurlistSupKey));
                    DynamicObject purlistCompObj = SrcAddSupplierFacade.createPurlistEntry(context, purlistCompMap, compMap, billId, turns, purlistId, supplierId, entityname);
                    if (purlistCompObj == null || purlistCompObjs.contains(purlistCompObj)) continue;
                    purlistCompObjs.add(purlistCompObj);
                    BizLog.log((String)String.format(ResManager.loadKDString((String)"\u8865\u5145\u4f9b\u5e94\u5546-\u521b\u5efa\u7684\u91c7\u8d2d\u6e05\u5355\u6dfb\u52a0\u5230\u96c6\u5408:%1$s\u3002", (String)"SrcAddSupplierHandler_9", (String)"scm-src-opplugin", (Object[])new Object[0]), purlistCompObjs.size()));
                }
            }
        }
        if (tenderSupObjs.size() > 0) {
            context.setEntityname("src_enrollsupplier");
            SrcAddSupplierFacade.createInviteSupplier(context, projectId, tenderSupObjs);
            context.setEntityname("src_supplierinvite");
            SrcAddSupplierFacade.createInviteSupplier(context, projectId, tenderSupObjs);
            SaveServiceHelper.save((DynamicObject[])tenderSupObjs.toArray(new DynamicObject[0]));
            BizLog.log((String)String.format(ResManager.loadKDString((String)"\u201c\u8865\u5145\u4f9b\u5e94\u5546-\u4fdd\u5b58\u56de\u6807\u8be6\u60c5\u201d\u4e3a%1$s\u3002", (String)"SrcAddSupplierHandler_10", (String)"scm-src-opplugin", (Object[])new Object[0]), tenderSupObjs.size()));
        }
        if (purlistCompObjs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])purlistCompObjs.toArray(new DynamicObject[0]));
            BizLog.log((String)String.format(ResManager.loadKDString((String)"\u8865\u5145\u4f9b\u5e94\u5546-\u4fdd\u5b58\u91c7\u8d2d\u6e05\u5355:%1$s", (String)"SrcAddSupplierHandler_11", (String)"scm-src-opplugin", (Object[])new Object[0]), purlistCompObjs.size()));
        }
        if ("src_decision".equals(entityname) && (tenderSupObjs.size() > 0 || purlistCompObjs.size() > 0)) {
            BizLog.log((String)ResManager.loadKDString((String)"\u3010\u8865\u5145\u4f9b\u5e94\u5546-\u5b9a\u6807\u5355\u8865\u5145\u4f9b\u5e94\u5546\u5220\u9664\u8bc4\u6807\u7ed3\u679c\u5e76\u8c03\u7528\u7efc\u5408\u8ba1\u7b97\u3011", (String)"SrcAddSupplierHandler_12", (String)"scm-src-opplugin", (Object[])new Object[0]));
            DeleteServiceHelper.delete((String)"src_bidassess_biz", (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)projectId)});
            SrcCalcHelper.syntheticalCalculate((String)"src_compare", (long)projectId);
        }
        BizLog.log((String)ResManager.loadKDString((String)"\u3010\u8865\u5145\u4f9b\u5e94\u5546-end\u3011", (String)"SrcAddSupplierHandler_13", (String)"scm-src-opplugin", (Object[])new Object[0]));
    }

    public DynamicObjectCollection getPurlistRows(SrcAddSupplierContext context, DynamicObject itemSupRow) {
        String addSupType;
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj().getDynamicObject("project"));
        switch (addSupType = PdsCommonUtils.object2String((Object)context.getBillObj().getString("addsupplier"), (String)"1")) {
            case "1": {
                return this.getProjectPurlist(projectId);
            }
            case "2": {
                return this.getPackagePurlist(projectId, itemSupRow.getLong("package.id"));
            }
            case "3": {
                return this.getBidPackagePurlist(projectId, itemSupRow.getString("packagename"));
            }
        }
        DynamicObjectCollection rows = new DynamicObjectCollection();
        rows.add((Object)itemSupRow);
        return rows;
    }

    public DynamicObjectCollection getProjectPurlist(long projectId) {
        QFilter qfilter = this.getBaseQFilter(projectId);
        return this.getPurlistRows(qfilter);
    }

    public DynamicObjectCollection getPackagePurlist(long projectId, long packageId) {
        QFilter qfilter = this.getBaseQFilter(projectId);
        qfilter.and("package", "=", (Object)packageId);
        return this.getPurlistRows(qfilter);
    }

    public DynamicObjectCollection getBidPackagePurlist(long projectId, String packagename) {
        QFilter qfilter = new QFilter("parentid", "=", (Object)String.valueOf(projectId));
        qfilter.and("packagename", "=", (Object)packagename);
        DynamicObject row = BusinessDataServiceHelper.loadSingle((String)"src_bidpackagef7", (String)"purlist", (QFilter[])qfilter.toArray());
        if (null == row) {
            return null;
        }
        qfilter = this.getBaseQFilter(projectId);
        Set purlistIds = MultiBasedataUtils.getBasedataIdSet((DynamicObject)row, (String)"purlist");
        qfilter.and("purlist", "in", (Object)purlistIds);
        return this.getPurlistRows(qfilter);
    }

    public QFilter getBaseQFilter(long projectId) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("supplier", "=", (Object)0L);
        Set purListEndIds = PdsPurlistUtils.getPurilstEndIds((long)projectId);
        qfilter.and("purlist.id", "not in", (Object)purListEndIds);
        return qfilter;
    }

    public DynamicObjectCollection getPurlistRows(QFilter qfilter) {
        return QueryServiceHelper.query((String)"src_purlistf7", (String)"purlist.id,purlist.package.id", (QFilter[])qfilter.toArray());
    }
}

