/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.aptitude;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsAptitudeUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcAptutidePublishValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public Set<String> getOnPreparePropertys() {
        HashSet<String> propertys = new HashSet<String>(8);
        propertys.add("aptitudedate");
        propertys.add("stopbiddate");
        return propertys;
    }

    public void validate(SrcValidatorData validatorData) {
        StringBuilder sb = new StringBuilder();
        this.validHasPublish(validatorData, sb);
        this.validAptOpenStatus(validatorData, sb);
        this.validAptitudeDate(validatorData, sb);
        this.validSupplier(validatorData, sb);
        if (sb.length() > 0) {
            validatorData.setSucced(false);
            validatorData.setMessage(sb.toString());
        }
    }

    public void validHasPublish(SrcValidatorData validatorData, StringBuilder sb) {
        QFilter qfilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)validatorData.getBillObj()));
        if (QueryServiceHelper.exists((String)"src_aptitudetask", (QFilter[])qfilter.toArray())) {
            sb.append(ResManager.loadKDString((String)"\u672c\u9879\u76ee\u5df2\u53d1\u5e03\u8d44\u5ba1\u5ba1\u67e5\uff0c\u8bf7\u5148\u64a4\u9500\u53d1\u5e03\u540e\uff0c\u518d\u91cd\u65b0\u53d1\u5e03\u3002", (String)"SrcAptutidePublishValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
        }
    }

    public void validAptOpenStatus(SrcValidatorData validatorData, StringBuilder sb) {
        if (PdsAptitudeUtils.isOpenApt((DynamicObject)validatorData.getBillObj(), (String)"isaptopen")) {
            sb.append(ResManager.loadKDString((String)"\u672c\u9879\u76ee\u5df2\u5f00\u8d44\u5ba1\u6807\uff0c\u8bf7\u52ff\u53d1\u5e03\u8d44\u8d28\u5ba1\u67e5\u3002", (String)"SrcAptutidePublishValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0]));
        }
    }

    public void validAptitudeDate(SrcValidatorData validatorData, StringBuilder sb) {
        Date stopbiddate;
        Date aptitudedate = validatorData.getBillObj().getDate("aptitudedate");
        if (null == aptitudedate) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!aptitudedate.after(TimeServiceHelper.now())) {
            sb.append(String.format(ResManager.loadKDString((String)"\u8d44\u5ba1\u622a\u6b62\u65f6\u95f4(%1$s)\u5e94\u665a\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"SrcAptutidePublishValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), sdf.format(aptitudedate)));
        }
        if (null != (stopbiddate = validatorData.getBillObj().getDate("stopbiddate")) && !aptitudedate.before(stopbiddate)) {
            sb.append(String.format(ResManager.loadKDString((String)"\u8d44\u5ba1\u622a\u6b62\u65f6\u95f4(%1$s)\u5e94\u65e9\u4e8e\u6295\u6807\u622a\u6b62\u65f6\u95f4(%2$s)\u3002", (String)"SrcAptutidePublishValidator_3", (String)"scm-src-opplugin", (Object[])new Object[0]), sdf.format(aptitudedate), sdf.format(stopbiddate)));
        }
    }

    public void validSupplier(SrcValidatorData validatorData, StringBuilder sb) {
        String suppliertype;
        QFilter qfilter = new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)validatorData.getBillObj()));
        switch (suppliertype = PdsCommonUtils.object2String((Object)validatorData.getBillObj().get("suppliertype"), (String)"2")) {
            case "1": {
                if (QueryServiceHelper.exists((String)"src_enrollsupplier", (QFilter[])qfilter.toArray())) break;
                sb.append(ResManager.loadKDString((String)"\u672c\u9879\u76ee\u65e0\u62a5\u540d\u4f9b\u5e94\u5546\uff0c\u8bf7\u52ff\u53d1\u5e03\u8d44\u8d28\u5ba1\u67e5\u3002", (String)"SrcAptutidePublishValidator_4", (String)"scm-src-opplugin", (Object[])new Object[0]));
                break;
            }
            case "2": {
                if (QueryServiceHelper.exists((String)"src_supplierinvite", (QFilter[])qfilter.toArray())) break;
                sb.append(ResManager.loadKDString((String)"\u672c\u9879\u76ee\u65e0\u9080\u8bf7\u4f9b\u5e94\u5546\uff0c\u8bf7\u52ff\u53d1\u5e03\u8d44\u8d28\u5ba1\u67e5\u3002", (String)"SrcAptutidePublishValidator_5", (String)"scm-src-opplugin", (Object[])new Object[0]));
                break;
            }
            case "3": {
                if (QueryServiceHelper.exists((String)"src_bidopensupplier", (QFilter[])qfilter.toArray())) break;
                sb.append(ResManager.loadKDString((String)"\u672c\u9879\u76ee\u65e0\u56de\u6807\u4f9b\u5e94\u5546\uff0c\u8bf7\u52ff\u53d1\u5e03\u8d44\u8d28\u5ba1\u67e5\u3002", (String)"SrcAptutidePublishValidator_6", (String)"scm-src-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

