/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.audithandle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcAptitudeAuditResultHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        DynamicObject[] configRows = this.getAptitudeConfig(context);
        if (null == configRows || configRows.length == 0) {
            return;
        }
        Map<Long, List<DynamicObject>> resultMap = this.getAptitudeResult(context, configRows);
        if (null == resultMap || resultMap.size() == 0) {
            return;
        }
        Map<Long, List<DynamicObject>> scoreTaskMap = this.getScoreTaskResult(context, configRows);
        this.updateAptitudeResult(configRows, resultMap, scoreTaskMap);
    }

    protected DynamicObject[] getAptitudeConfig(ExtPluginContext context) {
        if ("src_aptitudeaudit2".equals(context.getEntityId())) {
            return this.getConfigRows(context, "src_aptitudeconfig2f7", "billid");
        }
        return this.getConfigRows(context, "src_aptitudeconfigf7", "billid");
    }

    protected Map<Long, List<DynamicObject>> getAptitudeResult(ExtPluginContext context, DynamicObject[] configRows) {
        Set<Long> configIds = Arrays.asList(configRows).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] rows = null;
        rows = "src_aptitudeaudit2".equals(context.getEntityId()) ? this.getResultRows(context, "src_aptituderesult2f7", configIds) : this.getResultRows(context, "src_aptituderesultf7", configIds);
        if (rows.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getLong("scoretask.srcentryid")));
    }

    protected Map<Long, List<DynamicObject>> getScoreTaskResult(ExtPluginContext context, DynamicObject[] configRows) {
        Set<Long> configIds = Arrays.asList(configRows).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] rows = null;
        rows = this.getScoreTaskRows(context, "src_scoretask", configIds);
        if (rows.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getLong("srcentryid")));
    }

    protected void updateAptitudeResult(DynamicObject[] configRows, Map<Long, List<DynamicObject>> resultMap, Map<Long, List<DynamicObject>> scoreTaskMap) {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> scoreTaskList = new ArrayList<DynamicObject>(16);
        for (DynamicObject configRow : configRows) {
            List<DynamicObject> scoreTasks;
            List<DynamicObject> results = resultMap.get(configRow.getLong("id"));
            if (null != results && results.size() > 0) {
                for (DynamicObject result : results) {
                    if (result.getBigDecimal("scoretask.sumscore").compareTo(configRow.getBigDecimal("sumscore")) >= 0) {
                        result.set("isaptitude", (Object)"1");
                    } else {
                        result.set("isaptitude", (Object)"2");
                    }
                    resultList.add(result);
                }
            }
            if (null != (scoreTasks = scoreTaskMap.get(configRow.getLong("id"))) && scoreTasks.size() > 0) {
                for (DynamicObject scoreTask : scoreTasks) {
                    scoreTask.set("minvalue", (Object)configRow.getBigDecimal("sumscore"));
                    if (scoreTask.getBigDecimal("sumscore").compareTo(scoreTask.getBigDecimal("minvalue")) >= 0) {
                        scoreTask.set("isvalid", (Object)"1");
                    } else {
                        scoreTask.set("isvalid", (Object)"0");
                    }
                    scoreTaskList.add(scoreTask);
                }
            }
            configRow.set("ischanged", (Object)"0");
        }
        PdsCommonUtils.saveDynamicObjects(resultList);
        PdsCommonUtils.saveDynamicObjects(scoreTaskList);
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])configRows);
    }

    protected DynamicObject[] getConfigRows(ExtPluginContext context, String entityName, String keyField) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj());
        QFilter qfilters = new QFilter(keyField, "=", (Object)projectId);
        qfilters.and("ischanged", "=", (Object)"1");
        qfilters.and("sumscore", ">", (Object)BigDecimal.ZERO);
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilters.toArray());
    }

    protected DynamicObject[] getResultRows(ExtPluginContext context, String entityName, Set<Long> configIds) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj());
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
        qfilters.and("scoretask.srcentryid", "in", configIds);
        qfilters.and("scoretask.bizstatus", "=", (Object)"D");
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilters.toArray());
    }

    protected DynamicObject[] getScoreTaskRows(ExtPluginContext context, String entityName, Set<Long> configIds) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj());
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and("srcentryid", "in", configIds);
        qfilters.and("bizstatus", "=", (Object)"D");
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilters.toArray());
    }
}

