/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.audithandle;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcAptitudeUtils;

public class SrcAptitudeAuditResultHandler2
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.getResultMap(context);
        if (null == context.getParamMap() || context.getParamMap().size() == 0) {
            return;
        }
        this.handleEnrollSupplier(context);
        this.handleInviteSupplier(context);
        this.handleTenderSupplier(context);
        this.handleBiddoc(context);
        this.handleAptitudeTask(context);
    }

    protected void getResultMap(ExtPluginContext context) {
        DynamicObject[] rows = null;
        boolean isAptitude = false;
        if ("src_aptitudeaudit".equals(context.getEntityId())) {
            rows = this.getEntryRows(context, "src_aptituderesultf7", "billid");
            isAptitude = true;
        } else if ("src_aptitudeaudit2".equals(context.getEntityId())) {
            rows = this.getEntryRows(context, "src_aptituderesult2f7", "billid");
            isAptitude = true;
        } else {
            rows = this.getEntryRows(context, "src_bidassess_tec", "billid");
        }
        if (rows.length == 0) {
            return;
        }
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>(rows.length);
        boolean isByPackage = PdsCommonUtils.isByPackage((DynamicObject)context.getBillObj());
        boolean isByPurlist = null != rows[0].get("scoretask.purlist");
        for (DynamicObject row : rows) {
            String current;
            DynamicObject taskObj = row.getDynamicObject("scoretask");
            if (null == taskObj || !"D".equals(taskObj.getString("bizstatus")) || taskObj.getLong("purlist.id") > 0L || StringUtils.isBlank((CharSequence)(current = row.getString("isaptitude"))) || current.equals("0")) continue;
            String key = PdsCommonUtils.getSup_Pkg_Key((DynamicObject)taskObj, (boolean)isByPackage);
            DynamicObject obj = (DynamicObject)resultMap.get(key);
            if (null == obj) {
                resultMap.put(key, row);
                continue;
            }
            if (isAptitude || isByPurlist) {
                if (obj.getString("isaptitude").compareTo(current) <= 0) continue;
                resultMap.put(key, row);
                continue;
            }
            if (obj.getString("isaptitude").compareTo(current) >= 0) continue;
            resultMap.put(key, row);
        }
        context.setParamMap(resultMap);
    }

    protected void handleEnrollSupplier(ExtPluginContext context) {
        DynamicObject[] rows = this.getEntryRows(context, "src_enrollsupplier", "billid");
        this.updateAptitudeStatus(context, rows);
    }

    protected void handleInviteSupplier(ExtPluginContext context) {
        DynamicObject[] rows = this.getEntryRows(context, "src_supplierinvite", "billid");
        this.updateAptitudeStatus(context, rows);
    }

    protected void handleTenderSupplier(ExtPluginContext context) {
        DynamicObject[] rows = this.getEntryRows(context, "src_bidopensupplier", "billid");
        this.updateAptitudeStatus(context, rows);
    }

    protected void handleBiddoc(ExtPluginContext context) {
        DynamicObject[] rows = this.getEntryRows(context, "src_biddoctplf7", "project");
        this.updateAptitudeStatus(context, rows);
    }

    protected void handleAptitudeTask(ExtPluginContext context) {
        if (SrcAptitudeUtils.isSupplierReplyAptitude((DynamicObject)context.getBillObj())) {
            DynamicObject[] rows = this.getEntryRows(context, "src_aptitudetask", "project");
            this.updateAptitudeStatus(context, rows);
        }
    }

    protected void updateAptitudeStatus(ExtPluginContext context, DynamicObject[] rows) {
        if (rows.length == 0) {
            return;
        }
        Map resultMap = context.getParamMap();
        boolean isByPackage = PdsCommonUtils.isByPackage((DynamicObject)context.getBillObj());
        if (context.getOperationKey().equals("audit")) {
            for (DynamicObject row : rows) {
                String key = PdsCommonUtils.getSup_Pkg_Key((DynamicObject)row, (boolean)isByPackage);
                DynamicObject resultObj = (DynamicObject)resultMap.get(key);
                if (null == resultObj) continue;
                String value = resultObj.getString("isaptitude");
                if (rows[0].getDataEntityType().getName().equals("src_aptitudetask")) {
                    row.set("aptituderesult", (Object)value);
                } else {
                    row.set("isaptitude", (Object)value);
                }
                row.set("aptitudenote", (Object)resultObj.getString("aptitudenote"));
            }
        } else {
            for (DynamicObject row : rows) {
                String key = PdsCommonUtils.getSup_Pkg_Key((DynamicObject)row, (boolean)isByPackage);
                DynamicObject resultObj = (DynamicObject)resultMap.get(key);
                if (null == resultObj) continue;
                if (rows[0].getDataEntityType().getName().equals("src_aptitudetask")) {
                    row.set("aptituderesult", (Object)"0");
                } else {
                    row.set("isaptitude", (Object)"0");
                }
                row.set("aptitudenote", null);
            }
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    protected DynamicObject[] getEntryRows(ExtPluginContext context, String entityName, String keyField) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj());
        QFilter qfilters = new QFilter(keyField, "=", (Object)projectId);
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilters.toArray());
    }
}

