/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.audithandle;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bidopen.SrcBidOpenContext;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.bidopen.bidopencomm.SrcBidOpenOldDataDelete;

public class SrcAutoBidOpenHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public Set<String> getOnPreparePropertys() {
        HashSet<String> proSet = new HashSet<String>(2);
        proSet.add("sourceclass");
        proSet.add("srctype");
        return proSet;
    }

    public void process(ExtPluginContext context) {
        long sourceFlowId = context.getBillObj().getLong("srctype.id");
        boolean isAutoOpenAndPushScoreTask = PdsCommonUtils.object2Boolean((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isAutoOpenAndPushScoreTask", (Object)"0", (long)context.getProjectId()));
        if (!isAutoOpenAndPushScoreTask) {
            return;
        }
        this.autoBidOepn(context);
        this.autoPushScoreTask(context);
        SrcBidOpenFacade.setProjectOpenStatus((long)context.getProjectId());
    }

    public void autoBidOepn(ExtPluginContext context) {
        String selectFields = "istecopen,istecassess,isbizopen,tecopendate,tecopenuser,tecassessdate,bizopendate,bizopenuser";
        QFilter openFilter = new QFilter("billid", "=", (Object)context.getProjectId());
        DynamicObject[] openObjs = BusinessDataServiceHelper.load((String)"src_bidopenpackage", (String)selectFields, (QFilter[])openFilter.toArray());
        if (openObjs == null || openObjs.length == 0) {
            return;
        }
        for (DynamicObject openObj : openObjs) {
            if ("audit".equals(context.getOperationKey())) {
                openObj.set("istecopen", (Object)"1");
                openObj.set("tecopendate", (Object)TimeServiceHelper.now());
                openObj.set("tecopenuser", (Object)RequestContext.get().getCurrUserId());
                openObj.set("istecassess", (Object)"1");
                openObj.set("tecassessdate", (Object)TimeServiceHelper.now());
                openObj.set("isbizopen", (Object)"1");
                openObj.set("bizopendate", (Object)TimeServiceHelper.now());
                openObj.set("bizopenuser", (Object)RequestContext.get().getCurrUserId());
                continue;
            }
            openObj.set("istecopen", (Object)"0");
            openObj.set("tecopendate", null);
            openObj.set("tecopenuser", null);
            openObj.set("istecassess", (Object)"0");
            openObj.set("tecassessdate", null);
            openObj.set("isbizopen", (Object)"0");
            openObj.set("bizopendate", null);
            openObj.set("bizopenuser", null);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])openObjs);
    }

    public void autoPushScoreTask(ExtPluginContext context) {
        if ("audit".equals(context.getOperationKey())) {
            SrcBidOpenFacade.pushScoreTask(null, (DynamicObject)context.getBillObj(), (String)"allopen", Collections.emptyList(), (String)"pushscore");
        } else {
            SrcBidOpenContext bidOpenContext = new SrcBidOpenContext();
            bidOpenContext.setProjectId(context.getProjectId());
            SrcBidOpenOldDataDelete bidOpenOldDataDelete = new SrcBidOpenOldDataDelete();
            bidOpenOldDataDelete.process(bidOpenContext);
        }
    }
}

