/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.audithandle;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.EvaluateGradeEnums;
import kd.scm.pds.common.expertitem.PdsExpertItemUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcExpertAwardOrPunishHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)context.getBillId(), (String)context.getBillObj().getDataEntityType().getName());
        context.setBillObj(billObj);
        if (null == context.getBillObj().get("grade")) {
            return;
        }
        DynamicObject expertObj = this.getExpertObj(context);
        if (null == expertObj) {
            return;
        }
        this.updateExpert(context, expertObj);
    }

    public void updateExpert(ExtPluginContext context, DynamicObject expertObj) {
        DynamicObject billObj = context.getBillObj();
        if ("audit".equals(context.getOperationKey())) {
            this.auditHandle(billObj, expertObj);
        } else {
            this.unAuditHandle(billObj, expertObj);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject)expertObj);
    }

    public void auditHandle(DynamicObject billObj, DynamicObject expertObj) {
        PdsExpertItemUtils.expertUpdateLog((DynamicObject)expertObj, (String)"audit");
        expertObj.set("evaluatedate", (Object)TimeServiceHelper.now());
        if ("src_expertaward".equals(billObj.getDataEntityType().getName())) {
            expertObj.set("expertaward", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj));
            expertObj.set("srcbilltype", (Object)"2");
        } else {
            expertObj.set("expertpunish", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj));
            expertObj.set("srcbilltype", (Object)"3");
        }
        expertObj.set("evaluategrade", (Object)billObj.getLong("grade.id"));
        Object valueObj = billObj.get("grade.paramvalue");
        if (!StringUtils.isBlank((Object)valueObj)) {
            int month = Integer.parseInt(valueObj.toString());
            expertObj.set("pausefrom", (Object)TimeServiceHelper.now());
            expertObj.set("pauseto", (Object)DateUtil.addMonth((Date)TimeServiceHelper.now(), (int)month));
        } else {
            expertObj.set("pausefrom", null);
            expertObj.set("pauseto", null);
        }
        if (EvaluateGradeEnums.TERMINATE.getId() == billObj.getLong("grade.id")) {
            expertObj.set("enable", (Object)"0");
        }
    }

    public void unAuditHandle(DynamicObject billObj, DynamicObject expertObj) {
        boolean isAllowUnAudit = false;
        if ("src_expertaward".equals(billObj.getDataEntityType().getName())) {
            isAllowUnAudit = "2".equals(expertObj.getString("srcbilltype")) && SrmCommonUtil.getPkValue((DynamicObject)billObj) == expertObj.getLong("expertaward.id");
        } else {
            boolean bl = isAllowUnAudit = "3".equals(expertObj.getString("srcbilltype")) && SrmCommonUtil.getPkValue((DynamicObject)billObj) == expertObj.getLong("expertpunish.id");
        }
        if (isAllowUnAudit) {
            PdsExpertItemUtils.expertUpdateLog((DynamicObject)expertObj, (String)"unaudit");
        }
    }

    public DynamicObject getExpertObj(ExtPluginContext context) {
        QFilter qfilters = new QFilter("id", "=", (Object)context.getBillObj().getLong("expert.id"));
        qfilters.and("enable", "=", (Object)"1");
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_expert", (boolean)false);
        return BusinessDataServiceHelper.loadSingle((String)"src_expert", (String)selectFields, (QFilter[])qfilters.toArray());
    }
}

