/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.audithandle;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcExpertTrainHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)context.getBillId(), (String)context.getBillObj().getDataEntityType().getName());
        context.setBillObj(billObj);
        if (!context.getBillObj().getBoolean("ischanged")) {
            return;
        }
        DynamicObject expertObj = this.getExpertObj(context);
        if (null == expertObj) {
            return;
        }
        this.updateExpert(context, expertObj);
    }

    public void updateExpert(ExtPluginContext context, DynamicObject expertObj) {
        DynamicObject billObj = context.getBillObj();
        if ("audit".equals(context.getOperationKey())) {
            this.auditHandle(billObj, expertObj);
        } else {
            this.unAuditHandle(billObj, expertObj);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject)expertObj);
    }

    public void auditHandle(DynamicObject billObj, DynamicObject expertObj) {
        DynamicObjectCollection rows = expertObj.getDynamicObjectCollection("entry_aptitude");
        DynamicObject newRow = null;
        for (DynamicObject row : rows) {
            if (row.getLong("aptitudetype.id") != billObj.getLong("aptitudetype.id") || !row.getString("aptitudename").equals(billObj.getString("aptitudename")) || !row.getString("aptitudenumber").equals(billObj.getString("aptitudenumber"))) continue;
            newRow = row;
            break;
        }
        if (null == newRow) {
            newRow = rows.addNew();
            PdsCommonUtils.setPrimaryKey((DynamicObject)newRow);
        }
        newRow.set("experttrain", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj));
        newRow.set("aptitudetype", (Object)billObj.getLong("aptitudetype.id"));
        newRow.set("aptitudename", (Object)billObj.getString("aptitudename"));
        newRow.set("aptitudenumber", (Object)billObj.getString("aptitudenumber"));
        newRow.set("issueorg", (Object)billObj.getString("issueorg"));
        newRow.set("aptitudegrade", (Object)billObj.getString("aptitudegrade"));
        newRow.set("issuedate", (Object)billObj.getDate("issuedate"));
        newRow.set("dateto", (Object)billObj.getDate("dateto"));
        newRow.set("aptitudenote", (Object)billObj.getString("aptitudenote"));
        newRow.set("aptitude_fj", (Object)PdsCommonUtils.cloneAttachment((DynamicObject)billObj, (String)"aptitude_fj"));
    }

    public void unAuditHandle(DynamicObject billObj, DynamicObject expertObj) {
        DynamicObjectCollection rows = expertObj.getDynamicObjectCollection("entry_aptitude");
        for (DynamicObject row : rows) {
            if (row.getLong("experttrain.id") != billObj.getLong("id")) continue;
            rows.remove((Object)row);
            break;
        }
    }

    public DynamicObject getExpertObj(ExtPluginContext context) {
        return BusinessDataServiceHelper.loadSingle((Object)context.getBillObj().getLong("expert.id"), (String)"src_expert");
    }
}

