/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.audithandle;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsFlowConfigUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidCompTplUtil;

public class SrcProjectAuditPayment2
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        DynamicObject currBillObj = BusinessDataServiceHelper.loadSingle((Object)context.getBillObj().getPkValue(), (String)context.getBillObj().getDataEntityType().getName());
        List compKeys = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)currBillObj);
        if (!compKeys.contains("src_paymanage_cfg")) {
            return;
        }
        if (!PdsFlowConfigUtils.existsSpecificNode((DynamicObject)currBillObj, (String)PdsBizNodeEnums.PAYMANAGE.getValue())) {
            return;
        }
        String nextNodeNo = SrcBidCompTplUtil.getCurrNextNodeNo((DynamicObject)currBillObj);
        if (null == nextNodeNo || !PdsBizNodeEnums.PAYMANAGE.getValue().equals(nextNodeNo)) {
            return;
        }
        DynamicObjectCollection feeCfgObjs = QueryServiceHelper.query((String)"src_paymanage_cfg", (String)"id,feeway.id feewayid,feeway.number feeway", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)currBillObj))});
        if (null == feeCfgObjs || feeCfgObjs.size() == 0) {
            return;
        }
        String feeway = ((DynamicObject)feeCfgObjs.get(0)).getString("feeway");
        if (!"C020701".equals(feeway)) {
            return;
        }
        DynamicObject payBillObj = BusinessDataServiceHelper.loadSingle((Object)SrmCommonUtil.getPkValue((DynamicObject)currBillObj), (String)"src_paymanage");
        if (context.getOperationKey().equals("audit")) {
            this.audoAudit(payBillObj);
        }
    }

    private void audoAudit(DynamicObject billObj) {
        OperationResult result = PdsCommonUtils.doOperation((DynamicObject)billObj, (String)"submit");
        if (null != result && result.isSuccess()) {
            result = PdsCommonUtils.doOperation((DynamicObject)billObj, (String)"audit");
        }
    }
}

