/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.enroll;

import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.pds.common.enroll.IPdsEnrollHandler;
import kd.scm.pds.common.enroll.PdsEnrollContext;

public class SrcEnrollRecoveryHandle
implements IPdsEnrollHandler {
    private static final long serialVersionUID = 1L;

    public void process(PdsEnrollContext context) {
        if (context.isAutoPublish() && !context.isSucced()) {
            try (TXHandle h = TX.required();){
                try {
                    this.recoveryHandle(context);
                }
                catch (Exception e) {
                    h.markRollback();
                    this.logErrorMessage(context, e, null);
                }
            }
        }
    }

    protected void recoveryHandle(PdsEnrollContext context) {
        QFilter billFilter = new QFilter("billid", "=", (Object)context.getProjectId());
        billFilter.and("supplier.id", "=", (Object)context.getSupplierId());
        DeleteServiceHelper.delete((String)"src_enrollsupplier", (QFilter[])billFilter.toArray());
        DeleteServiceHelper.delete((String)"src_supplierinvite", (QFilter[])billFilter.toArray());
        DeleteServiceHelper.delete((String)"src_bidopensupplier", (QFilter[])billFilter.toArray());
        QFilter projectfilter = new QFilter("project", "=", (Object)context.getProjectId());
        projectfilter.and("supplier.id", "=", (Object)context.getSupplierId());
        DeleteServiceHelper.delete((String)"src_payment", (QFilter[])projectfilter.toArray());
        DeleteServiceHelper.delete((String)"tnd_tenderbill", (QFilter[])projectfilter.toArray());
        DeleteServiceHelper.delete((String)"tnd_quotebill", (QFilter[])projectfilter.toArray());
    }
}

