/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcAptitudeConfigPackageValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData srcValidatorData) {
        DynamicObject billObj = srcValidatorData.getBillObj();
        long projectId = billObj.getLong("id");
        QFilter qfilter = new QFilter("id", "=", (Object)projectId);
        DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_project", (String)"managetype", (QFilter[])qfilter.toArray());
        String manageType = projectObj.getString("managetype");
        if (!"2".equals(manageType)) {
            return;
        }
        Set<Long> allPackages = this.getPackageSet(projectId);
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        Set<Long> cfgPackages = this.getPackageSet(rows);
        if (allPackages.size() != cfgPackages.size()) {
            this.getUnSuccedResult(srcValidatorData, ResManager.loadKDString((String)"\u7ba1\u7406\u6309\u6807\u6bb5\uff0c\u9700\u8981\u8bbe\u7f6e\u6240\u6709\u6807\u6bb5\u7684\u8d44\u5ba1\u65b9\u6848\u3002", (String)"SrcAptitudeConfigPackageValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    private Set<Long> getPackageSet(long projectId) {
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_bidopenpackage", (String)"package.id", (QFilter[])qfilter.toArray());
        return this.getPackageSet(rows);
    }

    private Set<Long> getPackageSet(DynamicObjectCollection rows) {
        if (rows.size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(e -> e.getLong("package.id")).collect(Collectors.toSet());
    }
}

