/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcBatchDecisionAuditValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj().getDynamicObject("srctype"));
        boolean isBatchDecision = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isbatchdecision", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj())));
        if (isBatchDecision) {
            this.verifyBatchDecisionStatus(context);
        }
    }

    protected void verifyBatchDecisionStatus(SrcValidatorData context) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj());
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getVal());
        qfilter.and("template.biznode.number", "=", (Object)PdsBizNodeEnums.BATCHDECISION.getValue());
        if (QueryServiceHelper.exists((String)"src_batchdecision", (QFilter[])qfilter.toArray())) {
            context.setMessage(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5173\u8054\u7684\u5206\u6279\u5b9a\u6807\u5355\u6ca1\u6709\u5168\u90e8\u5ba1\u6838\uff0c\u8bf7\u5148\u5ba1\u6838\u540e\uff0c\u518d\u63d0\u4ea4\u3002", (String)"SrcBatchDecisionAuditValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
            context.setSucced(false);
        }
    }
}

