/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import org.apache.commons.lang3.StringUtils;

public class SrcBidOpenCfgPkgWeightValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObject billObj = context.getBillObj();
        HashMap<String, BigDecimal> baseTypeMap = new HashMap<String, BigDecimal>();
        if (billObj.getDataEntityType().getName().equals("src_aptitudeconfig") || billObj.getDataEntityType().getName().equals("src_aptitudeconfig2")) {
            baseTypeMap.put("4", new BigDecimal(100));
            baseTypeMap.put("7", new BigDecimal(100));
        } else if (billObj.getDataEntityType().getName().equals("src_evaluateconfig")) {
            baseTypeMap.put("8", new BigDecimal(100));
        } else {
            baseTypeMap.put("1", billObj.getBigDecimal("ratio_tec"));
            baseTypeMap.put("2", billObj.getBigDecimal("ratio_biz"));
            baseTypeMap.put("3", billObj.getBigDecimal("ratio_oth"));
            baseTypeMap.put("6", billObj.getBigDecimal("ratio_syn"));
        }
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        StringBuilder sb = new StringBuilder();
        HashMap<String, BigDecimal> weightMap = new HashMap<String, BigDecimal>();
        for (DynamicObject row : rows) {
            String key;
            if (row.getDynamicObject("indextype") == null) continue;
            String baseType = row.getDynamicObject("indextype").getString("basetype");
            weightMap.put(key, weightMap.get(key = row.getString("package.packagename") + "|" + baseType) == null ? row.getBigDecimal("weight") : row.getBigDecimal("weight").add((BigDecimal)weightMap.get(key)));
        }
        for (Map.Entry entry : weightMap.entrySet()) {
            boolean isNotEqual;
            String key = (String)entry.getKey();
            String[] splitKey = key.split("\\|");
            String packageName = splitKey[0];
            String baseType = splitKey[1];
            if (null == baseTypeMap.get(baseType)) continue;
            boolean bl = isNotEqual = ((BigDecimal)entry.getValue()).compareTo((BigDecimal)baseTypeMap.get(baseType)) > 0 || ((BigDecimal)entry.getValue()).compareTo((BigDecimal)baseTypeMap.get(baseType)) < 0;
            if (!isNotEqual) continue;
            String manageType = null;
            manageType = billObj.getDataEntityType().getName().equals("src_evaluateconfig") ? billObj.getString("managetype") : billObj.getString("projectf7.managetype");
            switch (baseType) {
                case "1": {
                    if (this.isByPackage(packageName, manageType)) {
                        sb.append(String.format(ResManager.loadKDString((String)"%1$s\u7684\u6280\u672f\u5360\u6bd4\u4e4b\u548c\u4e3a%2$s\uff0c\u4e0d\u7b49\u4e8e%3$s\u3002", (String)"SrcBidOpenCfgPkgWeightValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]), packageName, ((BigDecimal)weightMap.get(key)).setScale(2, 4), ((BigDecimal)baseTypeMap.get(baseType)).setScale(2, 4))).append("\n");
                        break;
                    }
                    sb.append(String.format(ResManager.loadKDString((String)"\u6280\u672f\u5360\u6bd4\u4e4b\u548c\u4e3a%1$s\uff0c\u4e0d\u7b49\u4e8e%2$s\u3002", (String)"SrcBidOpenCfgPkgWeightValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0]), ((BigDecimal)weightMap.get(key)).setScale(2, 4), ((BigDecimal)baseTypeMap.get(baseType)).setScale(2, 4))).append("\n");
                    break;
                }
                case "2": {
                    if (this.isByPackage(packageName, manageType)) {
                        sb.append(String.format(ResManager.loadKDString((String)"%1$s\u7684\u5546\u52a1\u5360\u6bd4\u4e4b\u548c\u4e3a%2$s\uff0c\u4e0d\u7b49\u4e8e%3$s\u3002", (String)"SrcBidOpenCfgPkgWeightValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), packageName, ((BigDecimal)weightMap.get(key)).setScale(2, 4), ((BigDecimal)baseTypeMap.get(baseType)).setScale(2, 4))).append("\n");
                        break;
                    }
                    sb.append(String.format(ResManager.loadKDString((String)"\u5546\u52a1\u5360\u6bd4\u4e4b\u548c\u4e3a%1$s\uff0c\u4e0d\u7b49\u4e8e%2$s\u3002", (String)"SrcBidOpenCfgPkgWeightValidator_3", (String)"scm-src-opplugin", (Object[])new Object[0]), ((BigDecimal)weightMap.get(key)).setScale(2, 4), ((BigDecimal)baseTypeMap.get(baseType)).setScale(2, 4))).append("\n");
                    break;
                }
                case "3": {
                    if (this.isByPackage(packageName, manageType)) {
                        sb.append(String.format(ResManager.loadKDString((String)"%1$s\u7684\u5546\u52a1\u7efc\u5408\u5360\u6bd4\u4e4b\u548c\u4e3a%2$s\uff0c\u4e0d\u7b49\u4e8e%3$s\u3002", (String)"SrcBidOpenCfgPkgWeightValidator_4", (String)"scm-src-opplugin", (Object[])new Object[0]), packageName, ((BigDecimal)weightMap.get(key)).setScale(2, 4), ((BigDecimal)baseTypeMap.get(baseType)).setScale(2, 4))).append("\n");
                        break;
                    }
                    sb.append(String.format(ResManager.loadKDString((String)"\u5546\u52a1\u7efc\u5408\u5360\u6bd4\u4e4b\u548c\u4e3a%1$s\uff0c\u4e0d\u7b49\u4e8e%2$s\u3002", (String)"SrcBidOpenCfgPkgWeightValidator_5", (String)"scm-src-opplugin", (Object[])new Object[0]), ((BigDecimal)weightMap.get(key)).setScale(2, 4), ((BigDecimal)baseTypeMap.get(baseType)).setScale(2, 4))).append("\n");
                    break;
                }
                case "6": {
                    if (this.isByPackage(packageName, manageType)) {
                        sb.append(String.format(ResManager.loadKDString((String)"%1$s\u7684\u7efc\u5408\u8bc4\u6807\u5360\u6bd4\u4e4b\u548c\u4e3a%2$s\uff0c\u4e0d\u7b49\u4e8e%3$s\u3002", (String)"SrcBidOpenCfgPkgWeightValidator_8", (String)"scm-src-opplugin", (Object[])new Object[0]), packageName, ((BigDecimal)weightMap.get(key)).setScale(2, 4), ((BigDecimal)baseTypeMap.get(baseType)).setScale(2, 4))).append("\n");
                        break;
                    }
                    sb.append(String.format(ResManager.loadKDString((String)"\u7efc\u5408\u8bc4\u6807\u5360\u6bd4\u4e4b\u548c\u4e3a%1$s\uff0c\u4e0d\u7b49\u4e8e%2$s\u3002", (String)"SrcBidOpenCfgPkgWeightValidator_9", (String)"scm-src-opplugin", (Object[])new Object[0]), ((BigDecimal)weightMap.get(key)).setScale(2, 4), ((BigDecimal)baseTypeMap.get(baseType)).setScale(2, 4))).append("\n");
                    break;
                }
                case "4": 
                case "7": {
                    if (this.isByPackage(packageName, manageType)) {
                        sb.append(String.format(ResManager.loadKDString((String)"%1$s\u7684\u8d44\u8d28\u5ba1\u67e5\u5360\u6bd4\u4e4b\u548c\u4e3a%2$s\uff0c\u4e0d\u7b49\u4e8e%3$s\u3002", (String)"SrcBidOpenCfgPkgWeightValidator_6", (String)"scm-src-opplugin", (Object[])new Object[0]), packageName, ((BigDecimal)weightMap.get(key)).setScale(2, 4), ((BigDecimal)baseTypeMap.get(baseType)).setScale(2, 4))).append("\n");
                        break;
                    }
                    sb.append(String.format(ResManager.loadKDString((String)"\u8d44\u8d28\u5ba1\u67e5\u5360\u6bd4\u4e4b\u548c\u4e3a%1$s\uff0c\u4e0d\u7b49\u4e8e%2$s\u3002", (String)"SrcBidOpenCfgPkgWeightValidator_7", (String)"scm-src-opplugin", (Object[])new Object[0]), ((BigDecimal)weightMap.get(key)).setScale(2, 4), ((BigDecimal)baseTypeMap.get(baseType)).setScale(2, 4))).append("\n");
                    break;
                }
                case "8": {
                    sb.append(String.format(ResManager.loadKDString((String)"\u4e13\u5bb6\u8003\u8bc4\u5360\u6bd4\u4e4b\u548c\u4e3a%1$s\uff0c\u4e0d\u7b49\u4e8e%2$s\u3002", (String)"SrcBidOpenCfgPkgWeightValidator_11", (String)"scm-src-opplugin", (Object[])new Object[0]), ((BigDecimal)weightMap.get(key)).setScale(2, 4), ((BigDecimal)baseTypeMap.get(baseType)).setScale(2, 4))).append("\n");
                    break;
                }
            }
        }
        if (sb.length() > 0) {
            context.setSucced(false);
            context.setMessage(sb.toString());
        }
    }

    private boolean isByPackage(String packageName, String manageType) {
        return StringUtils.isNotBlank((CharSequence)packageName) && "2".equals(manageType);
    }
}

