/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.pds.common.enums.BidDocTypeEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcBiddocTypeRepeatedValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public Set<String> getOnPreparePropertys() {
        HashSet<String> propertys = new HashSet<String>(8);
        propertys.add("entryentity.package");
        propertys.add("entryentity.fileclass");
        return propertys;
    }

    public void validate(SrcValidatorData context) {
        this.verifyUnique(context);
    }

    public void verifyUnique(SrcValidatorData context) {
        DynamicObjectCollection rows = context.getBillObj().getDynamicObjectCollection("entryentity");
        if (null == rows || rows.size() == 0) {
            return;
        }
        boolean isByPackage = "2".equals(context.getBillObj().getString("projectf7.managetype"));
        HashSet<String> set = new HashSet<String>(rows.size());
        HashSet<String> repeatSet = new HashSet<String>(rows.size());
        for (DynamicObject row : rows) {
            String fileTypeKey = this.getKey(row, isByPackage);
            if (null == fileTypeKey || set.add(fileTypeKey)) continue;
            repeatSet.add(fileTypeKey);
        }
        if (repeatSet.size() > 0) {
            if (isByPackage) {
                context.setMessage(String.format(ResManager.loadKDString((String)"\u540c\u4e00\u6807\u6bb5\u4e0d\u80fd\u5b58\u5728\u76f8\u540c\u6587\u4ef6\u7c7b\u578b+\u6587\u4ef6\u5206\u7c7b\uff1a%1$s", (String)"SrcBiddocTypeRepeatedValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), ((Object)repeatSet).toString()));
            } else {
                context.setMessage(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u5b58\u5728\u76f8\u540c\u6587\u4ef6\u7c7b\u578b+\u6587\u4ef6\u5206\u7c7b\uff1a%1$s", (String)"SrcBiddocTypeRepeatedValidator_3", (String)"scm-src-opplugin", (Object[])new Object[0]), ((Object)repeatSet).toString()));
            }
            context.setSucced(false);
        }
    }

    public String getKey(DynamicObject row, boolean isByPackage) {
        if (StringUtils.isBlank((Object)row.get("packfiletype"))) {
            return null;
        }
        String packfiletype = BidDocTypeEnums.getBidDocTypeName((String)row.getString("packfiletype"));
        if (isByPackage) {
            return PdsCommonUtils.buildString((Object[])new Object[]{row.get("package.packagename"), "_", packfiletype, "_", row.get("fileclass")});
        }
        return PdsCommonUtils.buildString((Object[])new Object[]{packfiletype, "_", row.get("fileclass")});
    }
}

