/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.src.common.enums.SrcDecisionEnum;

public class SrcDecisionSignSupplierValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        this.verifySupplierQty(context);
    }

    protected void verifySupplierQty(SrcValidatorData context) {
        String pentitykey = context.getBillObj().getString("pentitykey");
        if (!Objects.equals(pentitykey, "src_decision")) {
            return;
        }
        DynamicObjectCollection entryRows = context.getBillObj().getDynamicObjectCollection("entryentity");
        StringBuilder message = new StringBuilder();
        int i = 1;
        for (DynamicObject entryRow : entryRows) {
            DynamicObjectCollection subRows = entryRow.getDynamicObjectCollection("subentryentity");
            int supplierCount = (int)subRows.stream().filter(e -> null != e.getDynamicObject("signsupplier")).count();
            int contractType = entryRow.getInt("contracttype");
            if (contractType != supplierCount) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c,\u7b7e\u7ea6\u5c5e\u6027\u4e3a%2$s, \u7b7e\u7ea6\u4f9b\u5e94\u5546\u6570\u91cf\u53ea\u80fd\u6709%3$s\u4e2a\u3002", (String)"SrcDecisionSignSupplierValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]), i, SrcDecisionEnum.getContentByCode((String)String.valueOf(contractType)), contractType)).append('\n');
            }
            ++i;
        }
        if (message.length() > 0) {
            context.setSucced(false);
            context.setMessage(message.toString());
        }
    }
}

