/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcExpertUpdateUnAuditValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public Set<String> getOnPreparePropertys() {
        HashSet<String> propertys = new HashSet<String>(8);
        propertys.add("expert");
        propertys.add("grade");
        return propertys;
    }

    public void validate(SrcValidatorData context) {
        String entityName = context.getBillObj().getDataEntityType().getName();
        long billId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj());
        String srcBillType = null;
        String keyField = null;
        QFilter qfilter = null;
        switch (entityName) {
            case "src_expertevaluate": {
                qfilter = new QFilter("id", "in", this.getExpertIds(context));
                srcBillType = "1";
                keyField = "evaluate";
                break;
            }
            case "src_expertaward": {
                if (null == context.getBillObj().get("grade")) {
                    return;
                }
                qfilter = new QFilter("id", "=", (Object)context.getBillObj().getLong("expert.id"));
                srcBillType = "2";
                keyField = "expertaward";
                break;
            }
            case "src_expertpunish": {
                if (null == context.getBillObj().get("grade")) {
                    return;
                }
                qfilter = new QFilter("id", "=", (Object)context.getBillObj().getLong("expert.id"));
                srcBillType = "3";
                keyField = "expertpunish";
                break;
            }
        }
        if (null == qfilter) {
            return;
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_expert", (String)"name,srcbilltype,evaluate.id,evaluate.billno,evaluate.bidname,expertaward.number,expertaward.name,expertpunish.number,expertpunish.name,expertaward.id,expertpunish.id,enable", (QFilter[])qfilter.toArray());
        StringBuilder sb = new StringBuilder();
        for (DynamicObject row : rows) {
            if (!row.getBoolean("enable")) {
                sb.append(String.format(ResManager.loadKDString((String)"\u4e13\u5bb6(%s) \u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SrcExpertUpdateUnAuditValidator_7", (String)"scm-src-opplugin", (Object[])new Object[0]), row.getString("name")));
                sb.append("\n");
                continue;
            }
            if (srcBillType.equals(row.getString("srcbilltype")) && billId == row.getLong(keyField + '.' + "id")) continue;
            StringBuilder sb1 = new StringBuilder();
            if ("1".equals(row.getString("srcbilltype"))) {
                sb1.append(row.getString("evaluate.billno"));
                sb1.append("_");
                sb1.append(row.getString("evaluate.bidname"));
            } else if ("2".equals(row.getString("srcbilltype"))) {
                sb1.append(row.getString("expertaward.number"));
                sb1.append("_");
                sb1.append(row.getString("expertaward.name"));
            } else if ("3".equals(row.getString("srcbilltype"))) {
                sb1.append(row.getString("expertpunish.number"));
                sb1.append("_");
                sb1.append(row.getString("expertpunish.name"));
            }
            sb.append(String.format(ResManager.loadKDString((String)"\u4e13\u5bb6(%1$s) \u5df2\u7ecf\u88ab\u5176\u4ed6\u5355\u636e(%2$s) \u66f4\u65b0\u4e86\uff0c\u672c\u5355\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SrcExpertUpdateUnAuditValidator_10", (String)"scm-src-opplugin", (Object[])new Object[0]), row.getString("name"), sb1));
            sb.append("\n");
        }
        if (sb.length() > 0) {
            context.setMessage(sb.toString());
            context.setSucced(false);
        }
    }

    private Set<Long> getExpertIds(SrcValidatorData context) {
        long billId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj());
        QFilter qfilters = new QFilter("billid", "=", (Object)billId);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_evaluateresultf7", (String)"scoretask.supplier.id", (QFilter[])qfilters.toArray());
        if (null == rows || rows.size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(e -> e.getLong("scoretask.supplier.id")).collect(Collectors.toSet());
    }
}

