/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcInviteSupplierPurlistValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public Set<String> getOnPreparePropertys() {
        HashSet<String> propertySet = new HashSet<String>(2);
        propertySet.add("entrysupplier");
        propertySet.add("entrysupplier.purlists");
        return propertySet;
    }

    public void validate(SrcValidatorData context) {
        DynamicObjectCollection supRows = context.getBillObj().getDynamicObjectCollection("entrysupplier");
        if (supRows.size() == 0) {
            return;
        }
        HashSet selectIds = new HashSet(32);
        for (DynamicObject supRow : supRows) {
            Set selectIdSet = MultiBasedataUtils.getBasedataIdSet((DynamicObject)supRow, (String)"purlists");
            if (null == selectIdSet || selectIdSet.size() == 0) {
                return;
            }
            selectIds.addAll(selectIdSet);
        }
        QFilter purlistFilter = new QFilter("project", "=", (Object)context.getBillObj().getLong("projectf7.id"));
        purlistFilter.and("billtype", "=", (Object)"1");
        purlistFilter.and("isbizitem", "=", (Object)"0");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"id", (QFilter[])purlistFilter.toArray());
        Set purlistIds = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        if (purlistIds.size() != selectIds.size() || PdsCommonUtils.getIntersectSet(purlistIds, selectIds).size() != purlistIds.size()) {
            this.getUnSuccedResult(context, ResManager.loadKDString((String)"\u9009\u62e9\u4f9b\u5e94\u5546\u5173\u8054\u7684\u6807\u7684\uff0c\u4e0e\u901a\u7528\u62a5\u4ef7\u5355\u7684\u6807\u7684\u4e0d\u4e00\u81f4\uff0c\u53ef\u80fd\u9057\u6f0f\u6216\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u6e05\u7a7a\u3002", (String)"SrcInviteSupplierPurlistValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
            return;
        }
    }
}

