/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcNegotiateOpenDeadlineValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData validatorData) {
        DynamicObject negBillObj = validatorData.getBillObj();
        Date deadline = negBillObj.getDate("deadline");
        if (deadline != null && TimeServiceHelper.now().before(deadline)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u65f6\u95f4(%1$s)\u65e9\u4e8e\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4(%2$s), \u4e0d\u5141\u8bb8\u5f00\u6807\u3002", (String)"SrcNegotiateOpenDeadlineValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]), sdf.format(TimeServiceHelper.now()), sdf.format(deadline));
            validatorData.setSucced(false);
            validatorData.setMessage(message);
            return;
        }
    }
}

