/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcProjectDueDateValidator
implements ISrcValidator {
    private static final long serialVersionUID = 7491161532325806830L;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void validate(SrcValidatorData validatorData) {
        QFilter qfilter = new QFilter("id", "=", validatorData.getBillObj().getPkValue());
        DynamicObject baseObj = QueryServiceHelper.queryOne((String)"src_project_base", (String)"stopbiddate,replydate,opendate", (QFilter[])qfilter.toArray());
        if (baseObj == null) {
            return;
        }
        Date currentTime = TimeServiceHelper.now();
        Date replydate = baseObj.getDate("replydate");
        Date stopbiddate = baseObj.getDate("stopbiddate");
        Date opendate = baseObj.getDate("opendate");
        StringBuilder message = new StringBuilder();
        if (null != replydate || null != stopbiddate || null == opendate) {
            // empty if block
        }
        if (null != replydate && !replydate.after(currentTime)) {
            message.append(String.format(ResManager.loadKDString((String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4(%1$s)\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4(%2$s)\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SrcProjectDueDateValidator_5", (String)"scm-src-opplugin", (Object[])new Object[0]), sdf.format(replydate), sdf.format(currentTime)));
        }
        if (null != stopbiddate && !stopbiddate.after(currentTime)) {
            message.append(String.format(ResManager.loadKDString((String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4(%1$s)\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4(%2$s)\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SrcProjectDueDateValidator_6", (String)"scm-src-opplugin", (Object[])new Object[0]), sdf.format(stopbiddate), sdf.format(currentTime)));
        }
        if (null != opendate && !opendate.after(currentTime)) {
            message.append(String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u5f00\u6807\u65f6\u95f4(%1$s)\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4(%2$s)\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SrcProjectDueDateValidator_7", (String)"scm-src-opplugin", (Object[])new Object[0]), sdf.format(opendate), sdf.format(currentTime)));
        }
        if (null != stopbiddate && null != replydate && stopbiddate.before(replydate)) {
            message.append(String.format(ResManager.loadKDString((String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4(%1$s)\u4e0d\u80fd\u65e9\u4e8e\u62a5\u540d\u622a\u6b62\u65f6\u95f4(%2$s)\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SrcProjectDueDateValidator_10", (String)"scm-src-opplugin", (Object[])new Object[0]), sdf.format(stopbiddate), sdf.format(replydate)));
        }
        if (opendate != null) {
            if (null != replydate && !replydate.before(opendate)) {
                message.append(String.format(ResManager.loadKDString((String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4(%1$s)\u4e0d\u80fd\u665a\u4e8e\u9884\u8ba1\u5f00\u6807\u65f6\u95f4(%2$s)\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SrcProjectDueDateValidator_8", (String)"scm-src-opplugin", (Object[])new Object[0]), sdf.format(replydate), sdf.format(opendate)));
            }
            if (null != stopbiddate && !stopbiddate.before(opendate)) {
                message.append(String.format(ResManager.loadKDString((String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4(%1$s)\u4e0d\u80fd\u665a\u4e8e\u9884\u8ba1\u5f00\u6807\u65f6\u95f4(%2$s)\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SrcProjectDueDateValidator_9", (String)"scm-src-opplugin", (Object[])new Object[0]), sdf.format(stopbiddate), sdf.format(opendate)));
            }
        }
        if (message.length() > 0) {
            validatorData.setSucced(false);
            validatorData.setMessage(message.toString());
        }
    }
}

