/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcPurListStandCalValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObject billObj = context.getBillObj();
        String pentitykey = billObj.getString("pentitykey");
        if (Objects.equals(pentitykey, "tnd_quotebill") || Objects.equals(pentitykey, "tnd_tenderbill")) {
            String calPro = this.getCalPro(billObj);
            DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isEmpty((Collection)rows)) {
                int i = 1;
                StringBuilder sb = new StringBuilder();
                for (DynamicObject row : rows) {
                    if (!this.isCalRight(row, calPro)) {
                        sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u62a5\u4ef7\u672a\u7a0e\u91d1\u989d/\u4ef7\u7a0e\u5408\u8ba1\u4e0e\u5b9e\u9645\u516c\u5f0f\u8ba1\u7b97\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u62a5\u4ef7\u3002", (String)"SrcPurListStandCalValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]), i));
                        sb.append('\n');
                    }
                    ++i;
                }
                if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                    this.getUnSuccedResult(context, sb.toString());
                }
            }
        }
    }

    private boolean isCalRight(DynamicObject row, String calPro) {
        BigDecimal price_uom;
        BigDecimal qty = row.getBigDecimal("qty");
        int amtScale = this.getAmtPrecision(row);
        Object price_uomObj = row.get("price_uom");
        BigDecimal bigDecimal = price_uom = null == price_uomObj ? BigDecimal.ZERO : new BigDecimal(String.valueOf(price_uomObj));
        if ("taxprice".equals(calPro) || "taxamount".equals(calPro)) {
            BigDecimal currTaxAmount;
            BigDecimal taxPrice = row.getBigDecimal("taxprice");
            BigDecimal taxAmount = taxPrice.multiply(qty).setScale(amtScale, RoundingMode.HALF_UP);
            if (BigDecimal.ZERO.compareTo(price_uom) != 0) {
                taxAmount = taxAmount.divide(price_uom, RoundingMode.HALF_UP);
            }
            if (taxAmount.compareTo(currTaxAmount = row.getBigDecimal("taxamount")) != 0) {
                return false;
            }
        } else if ("price".equals(calPro) || "amount".equals(calPro)) {
            BigDecimal currAmount;
            BigDecimal price = row.getBigDecimal("price");
            BigDecimal amount = price.multiply(qty).setScale(amtScale, RoundingMode.HALF_UP);
            if (BigDecimal.ZERO.compareTo(price_uom) != 0) {
                amount = amount.divide(price_uom, RoundingMode.HALF_UP);
            }
            if (amount.compareTo(currAmount = row.getBigDecimal("amount")) != 0) {
                return false;
            }
        }
        return true;
    }

    private String getCalPro(DynamicObject billObj) {
        String taxType = billObj.getString("taxtype");
        String decisionType = billObj.getString("decisiontype");
        String calPro = "";
        if ("2".equals(decisionType)) {
            calPro = "taxamount";
            if ("2".equals(taxType)) {
                calPro = "amount";
            }
        } else {
            calPro = "taxprice";
            if ("2".equals(taxType)) {
                calPro = "price";
            }
        }
        return calPro;
    }

    private int getAmtPrecision(DynamicObject col) {
        int amtPrecision = 6;
        Object currency = col.get("currency");
        if (currency instanceof DynamicObject) {
            DynamicObject curr = (DynamicObject)currency;
            amtPrecision = curr.getInt("amtprecision");
        }
        return amtPrecision;
    }
}

