/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.math.BigDecimal;
import java.text.MessageFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcPurlistTieredQtyRangeValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObject billObj = context.getBillObj();
        String tieredType = PdsCommonUtils.object2String((Object)context.getBillObj().getString("projectf7.tieredtype"), (String)"1");
        if ("1".equals(tieredType)) {
            return;
        }
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        if (rows.size() == 0) {
            return;
        }
        int index = 0;
        StringBuilder message = new StringBuilder();
        for (DynamicObject row : rows) {
            DynamicObjectCollection subRows;
            if ("2".equals(tieredType)) {
                message.append((CharSequence)this.veryfyRange(row, "qtyfrom", "qtyto", index, -1));
            } else if ("3".equals(tieredType) && (subRows = row.getDynamicObjectCollection("subentryentity")).size() > 0) {
                int subIndex = 0;
                for (DynamicObject subRow : subRows) {
                    if (subIndex == subRows.size() - 1 && subRow.getBigDecimal("tieredqtyto").compareTo(BigDecimal.ZERO) == 0) {
                        subRow.set("tieredqtyto", (Object)999999999);
                    }
                    message.append((CharSequence)this.veryfyRange(subRow, "tieredqtyfrom", "tieredqtyto", index, subIndex));
                    ++subIndex;
                }
            }
            ++index;
        }
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            context.setSucced(false);
            context.setMessage(message.toString());
        }
    }

    private StringBuilder veryfyRange(DynamicObject row, String qtyFromField, String qtyFromTo, int index, int subIndex) {
        StringBuilder sb = new StringBuilder();
        if ((row.getBigDecimal(qtyFromField).compareTo(BigDecimal.ZERO) > 0 || row.getBigDecimal(qtyFromTo).compareTo(BigDecimal.ZERO) > 0) && row.getBigDecimal(qtyFromField).compareTo(row.getBigDecimal(qtyFromTo)) >= 0) {
            if (subIndex >= 0) {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u6807\u7684{0}-\u9636\u68af{1}\uff1a\u201c\u9636\u68af\u6570\u91cf\u4ece\u201d\u5e94\u5c0f\u4e8e\u201c\u9636\u68af\u6570\u91cf\u81f3\u201d\u3002", (String)"SrcPurlistTieredQtyRangeValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]), index + 1, subIndex + 1));
            } else {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u6807\u7684{0}\uff1a\u201c\u9636\u68af\u6570\u91cf\u4ece\u201d\u5e94\u5c0f\u4e8e\u201c\u9636\u68af\u6570\u91cf\u81f3\u201d", (String)"SrcPurlistTieredQtyRangeValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0]), index + 1));
            }
            sb.append('\n');
        }
        return sb;
    }
}

